/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.dispatch.DispatchFn;
import me.ehp246.aufjms.api.dispatch.DispatchFnProvider;
import me.ehp246.aufjms.api.dispatch.DispatchListener;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.exception.DispatchFnException;
import me.ehp246.aufjms.api.jms.AtDestination;
import me.ehp246.aufjms.api.jms.ContextProvider;
import me.ehp246.aufjms.api.jms.DestinationType;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.ToJson;
import me.ehp246.aufjms.core.util.OneUtil;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DefaultDispatchFnProvider
implements DispatchFnProvider {
    private static final Logger LOGGER = LogManager.getLogger(DefaultDispatchFnProvider.class);
    private final ContextProvider ctxProvider;
    private final ToJson toJson;
    private final List<DispatchListener> listeners;

    public DefaultDispatchFnProvider(ContextProvider ctxProvider, ToJson jsonFn, List<DispatchListener> dispatchListeners) {
        this.ctxProvider = Objects.requireNonNull(ctxProvider);
        this.toJson = jsonFn;
        this.listeners = dispatchListeners == null ? List.of() : Collections.unmodifiableList(dispatchListeners);
    }

    @Override
    public DispatchFn get(final String contextName) {
        return new DispatchFn(){
            private final JMSContext jmsCtx;
            {
                this.jmsCtx = DefaultDispatchFnProvider.this.ctxProvider.get(contextName);
            }

            @Override
            public JmsMsg dispatch(JmsDispatch dispatch) {
                LOGGER.atTrace().log("Sending {} {} to {} ", (Object)dispatch.type(), (Object)dispatch.correlationId(), (Object)dispatch.destination().name().toString());
                TextMessage message = this.jmsCtx.createTextMessage();
                try {
                    message.setText(DefaultDispatchFnProvider.this.toJson.apply(dispatch.bodyValues()));
                    for (Map.Entry entry : Optional.ofNullable(dispatch.properties()).orElseGet(HashMap::new).entrySet()) {
                        message.setObjectProperty((String)entry.getKey(), entry.getValue());
                    }
                    message.setJMSReplyTo(this.toJMSDestintation(dispatch.replyTo()));
                    message.setJMSType(dispatch.type());
                    message.setJMSCorrelationID(dispatch.correlationId());
                    message.setText(DefaultDispatchFnProvider.this.toJson.apply(dispatch.bodyValues()));
                }
                catch (JMSException e) {
                    LOGGER.atError().log("Message failed: destination {}, type {}, correclation id {}", (Object)dispatch.destination().toString(), (Object)dispatch.type(), (Object)dispatch.correlationId(), (Object)e);
                    throw new DispatchFnException(e);
                }
                this.jmsCtx.createProducer().setTimeToLive(Optional.ofNullable(dispatch.ttl()).map(Duration::toMillis).orElse(0L).longValue()).send(this.toJMSDestintation(dispatch.destination()), (Message)message);
                LOGGER.atTrace().log("Sent {} {}", (Object)dispatch.type(), (Object)dispatch.correlationId());
                JmsMsg msg = TextJmsMsg.from(message);
                DefaultDispatchFnProvider.this.listeners.stream().forEach(listener -> listener.onDispatch(msg, dispatch));
                return msg;
            }

            private Destination toJMSDestintation(AtDestination at) {
                if (at == null || !OneUtil.hasValue(at.name())) {
                    return null;
                }
                return at.type() == DestinationType.QUEUE ? this.jmsCtx.createQueue(at.name()) : this.jmsCtx.createTopic(at.name());
            }
        };
    }
}

