/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.jms.Message;
import me.ehp246.aufjms.api.annotation.OfProperty;
import me.ehp246.aufjms.api.annotation.OfType;
import me.ehp246.aufjms.api.endpoint.Executable;
import me.ehp246.aufjms.api.endpoint.ExecutableBinder;
import me.ehp246.aufjms.api.endpoint.InvocationContext;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.FromJson;
import me.ehp246.aufjms.core.reflection.CatchingInvocation;
import me.ehp246.aufjms.core.reflection.InvocationOutcome;

public final class DefaultExecutableBinder
implements ExecutableBinder {
    private static final Map<Class<? extends Annotation>, Function<JmsMsg, String>> HEADER_VALUE_SUPPLIERS = Map.of(OfType.class, JmsMsg::type);
    private static final Set<Class<? extends Annotation>> HEADER_ANNOTATIONS = Set.copyOf(HEADER_VALUE_SUPPLIERS.keySet());
    private final FromJson fromJson;

    public DefaultExecutableBinder(FromJson fromJson) {
        this.fromJson = fromJson;
    }

    @Override
    public CatchingInvocation bind(Executable target, InvocationContext ctx) {
        Method method = target.getMethod();
        if (method.getParameterCount() == 0) {
            return () -> {
                try {
                    method.setAccessible(true);
                    return InvocationOutcome.returned(method.invoke(target.getInstance(), (Object[])null));
                }
                catch (InvocationTargetException e1) {
                    return InvocationOutcome.thrown(e1.getCause());
                }
                catch (Exception e2) {
                    return InvocationOutcome.thrown(e2);
                }
            };
        }
        final Parameter[] parameters = method.getParameters();
        final Object[] arguments = new Object[parameters.length];
        boolean[] boundMarkers = this.bindContextArgs(parameters, ctx, arguments);
        ArrayList receivers = new ArrayList();
        for (int i = 0; i < boundMarkers.length; ++i) {
            if (boundMarkers[i]) continue;
            final Integer ref = i;
            receivers.add(new FromJson.Receiver<Object>(){

                @Override
                public void receive(Object value) {
                    arguments[ref.intValue()] = value;
                }

                @Override
                public Class<?> getType() {
                    return parameters[ref].getType();
                }

                @Override
                public List<? extends Annotation> getAnnotations() {
                    return List.of(parameters[ref].getAnnotations());
                }
            });
        }
        if (receivers.size() > 0) {
            this.fromJson.from(ctx.getMsg().text(), receivers);
        }
        return () -> {
            try {
                method.setAccessible(true);
                return InvocationOutcome.returned(method.invoke(target.getInstance(), arguments));
            }
            catch (InvocationTargetException e1) {
                return InvocationOutcome.thrown(e1.getCause());
            }
            catch (Exception e2) {
                return InvocationOutcome.thrown(e2);
            }
        };
    }

    private boolean[] bindContextArgs(Parameter[] parameters, InvocationContext ctx, Object[] arguments) {
        boolean[] markers = new boolean[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            JmsMsg msg = ctx.getMsg();
            Class<JmsMsg> type = parameter.getType();
            if (type.isAssignableFrom(JmsMsg.class)) {
                arguments[i] = msg;
                markers[i] = true;
            } else if (type.isAssignableFrom(Message.class)) {
                arguments[i] = msg.msg();
                markers[i] = true;
            }
            Annotation[] annotations = parameter.getAnnotations();
            Optional<Annotation> found = Stream.of(annotations).filter(annotation -> HEADER_ANNOTATIONS.contains(annotation.annotationType())).findAny();
            if (found.isPresent()) {
                arguments[i] = HEADER_VALUE_SUPPLIERS.get(found.get().annotationType()).apply(msg);
                markers[i] = true;
            }
            if (!(found = Stream.of(annotations).filter(annotation -> annotation.annotationType() == OfProperty.class).findAny()).isPresent()) continue;
            arguments[i] = msg.property(((OfProperty)found.get()).value(), parameter.getType());
            markers[i] = true;
        }
        return markers;
    }
}

