/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.ehp246.aufjms.api.jms.Invocation;
import me.ehp246.aufjms.core.reflection.AnnotatedArgument;

public final class DefaultProxyInvocation
implements Invocation {
    private final Class<?> declaringType;
    private final Object target;
    private final Method method;
    private final List<?> args;
    private final Annotation[][] parameterAnnotations;
    private final List<Class<?>> threws;

    public DefaultProxyInvocation(Class<?> declaringType, Object target, Method method, List<?> args) {
        this.declaringType = declaringType;
        this.target = target;
        this.method = Objects.requireNonNull(method);
        this.args = Collections.unmodifiableList(args == null ? new ArrayList() : args);
        this.parameterAnnotations = this.method.getParameterAnnotations();
        this.threws = List.of(this.method.getExceptionTypes());
    }

    public Class<?> declaringType() {
        return this.declaringType;
    }

    @Override
    public Object target() {
        return this.target;
    }

    @Override
    public Method method() {
        return this.method;
    }

    public List<? extends Annotation> getMethodDeclaredAnnotations() {
        return List.of(this.method.getDeclaredAnnotations());
    }

    public Class<?> getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    public String getDeclaringClassSimpleName() {
        return this.method.getDeclaringClass().getSimpleName();
    }

    @Override
    public List<?> args() {
        return this.args;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public boolean hasReturn() {
        return this.method.getReturnType() != Void.TYPE && this.method.getReturnType() != Void.class;
    }

    public boolean isAsync() {
        return this.getReturnType().isAssignableFrom(CompletableFuture.class);
    }

    public boolean isSync() {
        return !this.isAsync();
    }

    public List<Class<?>> getThrows() {
        return this.threws;
    }

    public boolean canThrow(Class<?> type) {
        return this.getThrows().stream().filter(t -> t.isAssignableFrom(type)).findAny().isPresent();
    }

    public boolean canReturn(Class<?> type) {
        return this.method.getReturnType().isAssignableFrom(type);
    }

    public List<?> filterPayloadArgs(Set<Class<? extends Annotation>> annotations) {
        ArrayList valueArgs = new ArrayList();
        for (int i = 0; i < this.parameterAnnotations.length; ++i) {
            if (Stream.of(this.parameterAnnotations[i]).filter(annotation -> annotations.contains(annotation.annotationType())).findAny().isPresent()) continue;
            valueArgs.add(this.args.get(i));
        }
        return valueArgs;
    }

    public <A extends Annotation, V> Optional<A> findOnDeclaringClass(Class<A> annotationClass) {
        return Optional.ofNullable(this.method.getDeclaringClass().getAnnotation(annotationClass));
    }

    public <R> List<R> findArgumentsOfType(Class<R> type) {
        ArrayList list = new ArrayList();
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!type.isAssignableFrom(parameterTypes[i])) continue;
            list.add(this.args.get(i));
        }
        return list;
    }

    public <K, V, A extends Annotation> Map<K, V> mapAnnotatedArguments(Class<A> annotationType, Function<A, K> keySupplier) {
        HashMap map = new HashMap();
        for (int i = 0; i < this.parameterAnnotations.length; ++i) {
            Optional<Annotation> found = Stream.of(this.parameterAnnotations[i]).filter(annotation -> annotation.annotationType() == annotationType).findFirst();
            if (found.isEmpty()) continue;
            map.put(keySupplier.apply(found.get()), this.args.get(i));
        }
        return map;
    }

    public <A extends Annotation> Stream<AnnotatedArgument<A>> streamOfAnnotatedArguments(Class<A> annotationType) {
        Stream.Builder builder = Stream.builder();
        for (int i = 0; i < this.parameterAnnotations.length; ++i) {
            Object arg = this.args.get(i);
            Parameter parameter = this.method.getParameters()[i];
            Stream.of(this.parameterAnnotations[i]).filter(annotation -> annotation.annotationType() == annotationType).map(anno -> new AnnotatedArgument<A>(){
                final /* synthetic */ Annotation val$anno;
                final /* synthetic */ Object val$arg;
                final /* synthetic */ Parameter val$parameter;
                {
                    this.val$anno = annotation;
                    this.val$arg = object;
                    this.val$parameter = parameter;
                }

                @Override
                public A annotation() {
                    return this.val$anno;
                }

                @Override
                public Object argument() {
                    return this.val$arg;
                }

                @Override
                public Parameter parameter() {
                    return this.val$parameter;
                }
            }).forEach(builder::add);
        }
        return builder.build();
    }

    public <A extends Annotation, V> Optional<V> optionalValueOnMethod(Class<A> annotationClass, Function<A, V> mapper) {
        return Optional.ofNullable(this.findOnMethod(annotationClass).map(mapper).orElse(null));
    }

    public <A extends Annotation, V> V firstArgumentAnnotationOf(Class<A> annotationClass, Function<AnnotatedArgument<A>, V> mapper, Supplier<V> supplier) {
        Optional<AnnotatedArgument<A>> found = this.streamOfAnnotatedArguments(annotationClass).findFirst();
        return found.isPresent() ? mapper.apply(found.get()) : supplier.get();
    }

    public <A extends Annotation, V> V methodAnnotationOf(Class<A> annotationClass, Function<A, V> mapper, Supplier<V> supplier) {
        Optional<A> found = this.findOnMethod(annotationClass);
        return found.isPresent() ? mapper.apply((Annotation)found.get()) : supplier.get();
    }

    public <A extends Annotation, V> V classAnnotationOf(Class<A> annotationClass, Function<A, V> mapper, Supplier<V> supplier) {
        Optional<A> found = this.findOnDeclaringClass(annotationClass);
        return found.isPresent() ? mapper.apply((Annotation)found.get()) : supplier.get();
    }

    public <A extends Annotation, V> V resolveAnnotatedValue(Class<A> annotationClass, Function<AnnotatedArgument<A>, V> argMapper, Function<A, V> methodMapper, Function<A, V> classMapper, Supplier<V> supplier) {
        return (V)this.firstArgumentAnnotationOf(annotationClass, argMapper, () -> this.methodAnnotationOf(annotationClass, methodMapper, () -> this.lambda$resolveAnnotatedValue$5(annotationClass, classMapper, (Supplier)supplier)));
    }

    public <A extends Annotation> Optional<A> findOnMethod(Class<A> annotationClass) {
        return Optional.ofNullable(this.method.getAnnotation(annotationClass));
    }

    public <A extends Annotation> Optional<A> findOnMethodUp(Class<A> annotationClass) {
        Optional<A> found = Optional.ofNullable(this.method.getAnnotation(annotationClass));
        if (found.isPresent()) {
            return found;
        }
        return Optional.ofNullable(this.getDeclaringClass().getAnnotation(annotationClass));
    }

    public String getMethodName() {
        return this.method.getName();
    }

    private /* synthetic */ Object lambda$resolveAnnotatedValue$5(Class annotationClass, Function classMapper, Supplier supplier) {
        return this.classAnnotationOf(annotationClass, classMapper, supplier);
    }
}

