/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.util;

import java.time.Instant;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.jms.JmsMsg;

public final class TextJmsMsg
implements JmsMsg {
    private final TextMessage message;

    private TextJmsMsg(TextMessage message) {
        this.message = message;
    }

    @Override
    public String id() {
        return JMSSupplier.invoke(() -> ((TextMessage)this.message).getJMSMessageID());
    }

    @Override
    public String type() {
        return JMSSupplier.invoke(() -> ((TextMessage)this.message).getJMSType());
    }

    @Override
    public String correlationId() {
        return JMSSupplier.invoke(() -> ((TextMessage)this.message).getJMSCorrelationID());
    }

    @Override
    public Destination replyTo() {
        return JMSSupplier.invoke(() -> ((TextMessage)this.message).getJMSReplyTo());
    }

    @Override
    public String text() {
        return JMSSupplier.invoke(() -> ((TextMessage)this.message).getText());
    }

    @Override
    public String groupId() {
        return JMSSupplier.invoke(() -> this.message.getStringProperty("JMSXGroupID"));
    }

    @Override
    public Integer groupSeq() {
        return JMSSupplier.invoke(() -> this.message.getIntProperty("JMSXGroupSeq"));
    }

    @Override
    public long expiration() {
        return JMSSupplier.invoke(() -> ((TextMessage)this.message).getJMSExpiration());
    }

    @Override
    public Destination destination() {
        return JMSSupplier.invoke(() -> ((TextMessage)this.message).getJMSDestination());
    }

    @Override
    public String invoking() {
        return JMSSupplier.invoke(() -> this.message.getStringProperty("AufJmsInvoking"));
    }

    @Override
    public <T> T property(String name, Class<T> type) {
        if (type == String.class) {
            return (T)JMSSupplier.invoke(() -> this.message.getStringProperty(name));
        }
        if (type == Integer.TYPE) {
            return (T)JMSSupplier.invoke(() -> this.message.getIntProperty(name));
        }
        if (type == Long.TYPE) {
            return (T)JMSSupplier.invoke(() -> this.message.getLongProperty(name));
        }
        if (type == Boolean.TYPE) {
            return (T)JMSSupplier.invoke(() -> this.message.getBooleanProperty(name));
        }
        throw new RuntimeException("Un-supported property type " + type.getTypeName());
    }

    @Override
    public Instant timestamp() {
        return Instant.ofEpochMilli(JMSSupplier.invoke(() -> ((TextMessage)this.message).getJMSTimestamp()));
    }

    @Override
    public TextMessage msg() {
        return this.message;
    }

    public static JmsMsg from(TextMessage message) {
        return new TextJmsMsg(message);
    }

    private static interface JMSSupplier<V> {
        public V get() throws JMSException;

        public static <V> V invoke(JMSSupplier<V> callable) {
            try {
                return callable.get();
            }
            catch (JMSException e) {
                throw new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
        }
    }
}

