/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.Objects;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.endpoint.ExecutableBinder;
import me.ehp246.aufjms.api.endpoint.ExecutorProvider;
import me.ehp246.aufjms.api.endpoint.InboundEndpoint;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.endpoint.DefaultInvokableDispatcher;
import me.ehp246.aufjms.core.jms.AtDestinationRecord;
import me.ehp246.aufjms.core.util.OneUtil;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.MessageListenerContainer;

public final class InboundListenerConfigurer
implements JmsListenerConfigurer {
    private static final Logger LOGGER = LogManager.getLogger(InboundListenerConfigurer.class);
    private final Set<InboundEndpoint> endpoints;
    private final ExecutorProvider executorProvider;
    private final ExecutableBinder binder;
    private final PropertyResolver propertyResolver;
    private final ConnectionFactory connectionFactory;

    public InboundListenerConfigurer(ConnectionFactory connectionFactory, Set<InboundEndpoint> endpoints, ExecutorProvider executorProvider, ExecutableBinder binder, PropertyResolver propertyResolver) {
        this.connectionFactory = Objects.requireNonNull(connectionFactory);
        this.endpoints = endpoints;
        this.executorProvider = executorProvider;
        this.binder = binder;
        this.propertyResolver = propertyResolver;
    }

    public void configureJmsListeners(JmsListenerEndpointRegistrar registrar) {
        DefaultJmsListenerContainerFactory listenerContainerFactory = this.jmsListenerContainerFactory();
        this.endpoints.stream().forEach(endpoint -> {
            AtDestinationRecord resolvedAt = new AtDestinationRecord(this.propertyResolver.resolve(endpoint.at().name()), endpoint.at().type());
            LOGGER.atDebug().log("Registering '{}' endpoint at {}", (Object)endpoint.name(), (Object)resolvedAt.toString());
            DefaultInvokableDispatcher dispatcher = new DefaultInvokableDispatcher(endpoint.resolver(), this.binder, this.executorProvider.get(Integer.parseInt(this.propertyResolver.resolve(endpoint.concurrency()))));
            registrar.registerEndpoint(new JmsListenerEndpoint(){
                final /* synthetic */ InboundEndpoint val$endpoint;
                final /* synthetic */ AtDestinationRecord val$resolvedAt;
                final /* synthetic */ DefaultInvokableDispatcher val$dispatcher;
                {
                    this.val$endpoint = inboundEndpoint;
                    this.val$resolvedAt = atDestinationRecord;
                    this.val$dispatcher = defaultInvokableDispatcher;
                }

                public void setupListenerContainer(MessageListenerContainer listenerContainer) {
                    AbstractMessageListenerContainer container = (AbstractMessageListenerContainer)listenerContainer;
                    container.setBeanName(OneUtil.hasValue(this.val$endpoint.name()) ? this.val$endpoint.name() : this.val$resolvedAt.toString());
                    container.setDestinationName(this.val$resolvedAt.toString());
                    container.setDestinationResolver((session, name, topic) -> this.val$resolvedAt.jmsDestination(session));
                    container.setupMessageListener(message -> {
                        JmsMsg msg = TextJmsMsg.from((TextMessage)message);
                        ThreadContext.put((String)"AufJms-Msg-Type", (String)msg.type());
                        ThreadContext.put((String)"AufJms-Correlation-Id", (String)msg.correlationId());
                        this.val$dispatcher.dispatch(msg);
                        ThreadContext.remove((String)"AufJms-Msg-Type");
                        ThreadContext.remove((String)"AufJms-Correlation-Id");
                    });
                }

                public String getId() {
                    return this.val$endpoint.name();
                }
            }, (JmsListenerContainerFactory)listenerContainerFactory);
        });
    }

    private DefaultJmsListenerContainerFactory jmsListenerContainerFactory() {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(this.connectionFactory);
        return factory;
    }
}

