/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.configuration;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import me.ehp246.aufjms.api.jms.ContextProvider;

final class DefaultContextProvider
implements ContextProvider,
AutoCloseable {
    private final ConnectionFactory connectionFactory;
    private final Map<String, JMSContext> map = new ConcurrentHashMap<String, JMSContext>();

    DefaultContextProvider(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public JMSContext get(String name) {
        return this.map.computeIfAbsent(name == null ? "" : name, key -> this.connectionFactory.createContext());
    }

    @Override
    public void close() {
        this.map.entrySet().stream().map(Map.Entry::getValue).forEach(ctx -> ctx.close());
    }
}

