/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.ehp246.aufjms.api.dispatch.DispatchConfig;
import me.ehp246.aufjms.api.dispatch.DispatchFn;
import me.ehp246.aufjms.api.dispatch.DispatchFnProvider;
import me.ehp246.aufjms.api.dispatch.InvocationDispatchBuilder;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.jms.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ByJmsFactory {
    private static final Logger LOGGER = LogManager.getLogger(ByJmsFactory.class);
    private final InvocationDispatchBuilder dispatchProvider;
    private final DispatchFnProvider dispatchFnProvider;

    public ByJmsFactory(DispatchFnProvider dispatchFnProvider, InvocationDispatchBuilder dispatchProvider) {
        this.dispatchProvider = dispatchProvider;
        this.dispatchFnProvider = dispatchFnProvider;
    }

    public <T> T newInstance(Class<T> byJmsInterface, DispatchConfig jmsProxyConfig) {
        LOGGER.atDebug().log("Instantiating {}", (Object)byJmsInterface.getCanonicalName());
        DispatchFn dispatchFn = this.dispatchFnProvider.get(jmsProxyConfig.context());
        int hashCode = new Object().hashCode();
        return (T)Proxy.newProxyInstance(byJmsInterface.getClassLoader(), new Class[]{byJmsInterface}, (proxy, method, args) -> {
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            if (method.getName().equals("hashCode")) {
                return hashCode;
            }
            if (method.getName().equals("equals")) {
                if (proxy == args[0]) {
                    return true;
                }
                return false;
            }
            if (method.isDefault()) {
                return MethodHandles.privateLookupIn(byJmsInterface, MethodHandles.lookup()).findSpecial(byJmsInterface, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), byJmsInterface).bindTo(proxy).invokeWithArguments(args);
            }
            JmsDispatch jmsDispatch = this.dispatchProvider.get(new Invocation(args){
                private final List<?> asList;
                {
                    this.asList = Collections.unmodifiableList(objectArray == null ? List.of() : Arrays.asList(objectArray));
                }

                @Override
                public Object target() {
                    return proxy;
                }

                @Override
                public Method method() {
                    return method;
                }

                @Override
                public List<?> args() {
                    return this.asList;
                }
            }, jmsProxyConfig);
            dispatchFn.dispatch(jmsDispatch);
            return null;
        });
    }
}

