/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.dispatch.DispatchListener;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.exception.JmsDispatchFnException;
import me.ehp246.aufjms.api.jms.AtDestination;
import me.ehp246.aufjms.api.jms.AufJmsContext;
import me.ehp246.aufjms.api.jms.ConnectionFactoryProvider;
import me.ehp246.aufjms.api.jms.DestinationType;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.ToJson;
import me.ehp246.aufjms.core.util.OneUtil;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DefaultDispatchFnProvider
implements JmsDispatchFnProvider,
AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(DefaultDispatchFnProvider.class);
    private final ConnectionFactoryProvider cfProvider;
    private final ToJson toJson;
    private final List<DispatchListener> listeners;
    private final Set<Connection> closeable = ConcurrentHashMap.newKeySet();

    public DefaultDispatchFnProvider(ConnectionFactoryProvider cfProvider, ToJson jsonFn, List<DispatchListener> dispatchListeners) {
        this.cfProvider = Objects.requireNonNull(cfProvider);
        this.toJson = Objects.requireNonNull(jsonFn);
        this.listeners = dispatchListeners == null ? List.of() : Collections.unmodifiableList(dispatchListeners);
    }

    @Override
    public JmsDispatchFn get(final String connectionFactoryName) {
        Connection connection;
        if (connectionFactoryName != null) {
            try {
                connection = this.cfProvider.get(connectionFactoryName).createConnection();
            }
            catch (Exception e) {
                LOGGER.atError().log("Failed to create connection on factory {}:{}", (Object)connectionFactoryName, (Object)e.getMessage());
                throw new JmsDispatchFnException(e);
            }
            this.closeable.add(connection);
        } else {
            connection = null;
        }
        return new JmsDispatchFn(){
            private final Logger LOGGER;
            {
                this.LOGGER = LogManager.getLogger((String)(String.valueOf(JmsDispatchFn.class.getName()) + "@" + string));
            }

            @Override
            public JmsMsg send(JmsDispatch dispatch) {
                if (connection == null && AufJmsContext.getSession() == null) {
                    throw new JmsDispatchFnException("No session can be created");
                }
                this.LOGGER.atTrace().log("Sending {} {} to {} on {}", (Object)dispatch.type(), (Object)dispatch.correlationId(), (Object)dispatch.at().name().toString(), (Object)connectionFactoryName);
                Session session = null;
                MessageProducer producer = null;
                try {
                    session = connection != null ? connection.createSession() : AufJmsContext.getSession();
                    producer = session.createProducer(null);
                    TextMessage message = session.createTextMessage();
                    for (Map.Entry entry : Optional.ofNullable(dispatch.properties()).orElseGet(HashMap::new).entrySet()) {
                        message.setObjectProperty(((String)entry.getKey()).toString(), entry.getValue());
                    }
                    message.setJMSReplyTo(DefaultDispatchFnProvider.toJMSDestintation(session, dispatch.replyTo()));
                    message.setJMSType(dispatch.type());
                    message.setJMSCorrelationID(dispatch.correlationId());
                    message.setText(DefaultDispatchFnProvider.this.toJson.apply(dispatch.bodyValues()));
                    producer.setDeliveryDelay(Optional.ofNullable(dispatch.delay()).map(Duration::toMillis).orElse(0L).longValue());
                    producer.setTimeToLive(Optional.ofNullable(dispatch.ttl()).map(Duration::toMillis).orElse(0L).longValue());
                    producer.send(DefaultDispatchFnProvider.toJMSDestintation(session, dispatch.at()), (Message)message);
                    this.LOGGER.atTrace().log("Sent {} {}", (Object)dispatch.type(), (Object)dispatch.correlationId());
                    JmsMsg msg = TextJmsMsg.from(message);
                    DefaultDispatchFnProvider.this.listeners.stream().forEach(listener -> listener.onDispatch(msg, dispatch));
                    JmsMsg jmsMsg = msg;
                    return jmsMsg;
                }
                catch (JMSException e) {
                    this.LOGGER.atError().log("Message failed: destination {}, type {}, correclation id {}", (Object)dispatch.at().toString(), (Object)dispatch.type(), (Object)dispatch.correlationId(), (Object)e);
                    throw new JmsDispatchFnException(e);
                }
                finally {
                    if (producer != null) {
                        try {
                            producer.close();
                        }
                        catch (JMSException e) {
                            this.LOGGER.atError().log("Failed to close producer. Ignored", (Object)e);
                        }
                    }
                    if (connection != null && session != null) {
                        try {
                            session.close();
                        }
                        catch (JMSException e) {
                            this.LOGGER.atError().log("Failed to close session. Ignored.", (Object)e);
                        }
                    }
                }
            }
        };
    }

    private static Destination toJMSDestintation(Session session, AtDestination at) throws JMSException {
        if (at == null || !OneUtil.hasValue(at.name())) {
            return null;
        }
        return at.type() == DestinationType.QUEUE ? session.createQueue(at.name()) : session.createTopic(at.name());
    }

    @Override
    public void close() {
        this.closeable.stream().forEach(t -> {
            try {
                t.close();
            }
            catch (JMSException e) {
                LOGGER.atError().log("Failed to close connection. Ignored", (Object)e);
            }
        });
        this.closeable.clear();
    }
}

