/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Consumer;
import me.ehp246.aufjms.api.endpoint.Executable;
import me.ehp246.aufjms.api.endpoint.ExecutableResolver;
import me.ehp246.aufjms.api.endpoint.ExecutedInstance;
import me.ehp246.aufjms.api.endpoint.InstanceScope;
import me.ehp246.aufjms.api.endpoint.InvocationModel;
import me.ehp246.aufjms.api.endpoint.InvokableResolver;
import me.ehp246.aufjms.api.endpoint.ResolvedInstanceType;
import me.ehp246.aufjms.api.jms.JmsMsg;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public final class AutowireCapableExecutableResolver
implements ExecutableResolver {
    private final AutowireCapableBeanFactory autowireCapableBeanFactory;
    private final InvokableResolver typeResolver;

    public AutowireCapableExecutableResolver(AutowireCapableBeanFactory autowireCapableBeanFactory, InvokableResolver resolver) {
        this.autowireCapableBeanFactory = autowireCapableBeanFactory;
        this.typeResolver = resolver;
    }

    @Override
    public Executable resolve(JmsMsg msg) {
        Objects.requireNonNull(msg);
        final ResolvedInstanceType registered = this.typeResolver.resolve(msg);
        if (registered == null) {
            return null;
        }
        final Object executableInstance = registered.getScope().equals((Object)InstanceScope.BEAN) ? this.autowireCapableBeanFactory.getBean(registered.getInstanceType()) : this.autowireCapableBeanFactory.createBean(registered.getInstanceType());
        return new Executable(){

            @Override
            public Method getMethod() {
                return registered.getMethod();
            }

            @Override
            public Object getInstance() {
                return executableInstance;
            }

            @Override
            public InvocationModel getInvocationModel() {
                return registered.getInvocationModel();
            }

            @Override
            public Consumer<ExecutedInstance> executionConsumer() {
                return null;
            }
        };
    }
}

