/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.endpoint.Executable;
import me.ehp246.aufjms.api.endpoint.ExecutableBinder;
import me.ehp246.aufjms.api.endpoint.ExecutableResolver;
import me.ehp246.aufjms.api.endpoint.ExecutedInstance;
import me.ehp246.aufjms.api.endpoint.InvocationModel;
import me.ehp246.aufjms.api.endpoint.InvokableDispatcher;
import me.ehp246.aufjms.api.jms.AtDestination;
import me.ehp246.aufjms.api.jms.AufJmsContext;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.jms.AtDestinationRecord;
import me.ehp246.aufjms.core.reflection.InvocationOutcome;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.jms.listener.SessionAwareMessageListener;

final class DefaultInvokableDispatcher
implements InvokableDispatcher,
SessionAwareMessageListener<Message> {
    private static final Logger LOGGER = LogManager.getLogger(DefaultInvokableDispatcher.class);
    private final Executor executor;
    private final ExecutableResolver executableResolver;
    private final ExecutableBinder binder;
    private final JmsDispatchFn dispatchFn;

    DefaultInvokableDispatcher(ExecutableResolver executableResolver, ExecutableBinder binder, Executor executor, JmsDispatchFn dispatchFn) {
        this.executableResolver = executableResolver;
        this.binder = binder;
        this.executor = executor;
        this.dispatchFn = dispatchFn;
    }

    public void onMessage(Message message, Session session) throws JMSException {
        if (!(message instanceof TextMessage)) {
            throw new RuntimeException("Un-supported Message type: " + message.getClass().getSimpleName());
        }
        try {
            AufJmsContext.set(session);
            ThreadContext.put((String)"AufJms-Msg-Type", (String)message.getJMSType());
            ThreadContext.put((String)"AufJms-Correlation-Id", (String)message.getJMSCorrelationID());
            LOGGER.atTrace().log("Dispatching");
            this.dispatch(TextJmsMsg.from((TextMessage)message));
            LOGGER.atTrace().log("Dispatched");
        }
        finally {
            ThreadContext.remove((String)"AufJms-Msg-Type");
            ThreadContext.remove((String)"AufJms-Correlation-Id");
            AufJmsContext.clearSession();
        }
    }

    @Override
    public void dispatch(JmsMsg msg) {
        LOGGER.atTrace().log("Resovling {}", (Object)msg.type());
        InvocationOutcome<Executable> resolveOutcome = InvocationOutcome.invoke(() -> this.executableResolver.resolve(msg));
        if (resolveOutcome.hasThrown()) {
            LOGGER.atError().log("Resolution failed", (Object)resolveOutcome.getThrown().getMessage());
            Throwable ex = resolveOutcome.getThrown();
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        Executable target = resolveOutcome.getReturned();
        if (target == null) {
            LOGGER.atInfo().log("Un-matched message {} {}", (Object)msg.type(), (Object)msg.correlationId());
            return;
        }
        LOGGER.atTrace().log("Submitting {}", (Object)target.getMethod());
        Supplier<InvocationOutcome<?>> outcomeSupplier = this.newSupplier(msg, target);
        if (this.executor == null || target.getInvocationModel() != null && target.getInvocationModel() == InvocationModel.INLINE) {
            LOGGER.atTrace().log("Executing");
            Throwable thrown = outcomeSupplier.get().getThrown();
            if (thrown != null) {
                if (thrown instanceof RuntimeException) {
                    throw (RuntimeException)thrown;
                }
                throw new RuntimeException(thrown);
            }
            LOGGER.atTrace().log("Executed");
        } else {
            this.executor.execute(() -> {
                ThreadContext.put((String)"AufJms-Msg-Type", (String)msg.type());
                ThreadContext.put((String)"AufJms-Correlation-Id", (String)msg.correlationId());
                LOGGER.atTrace().log("Executing");
                outcomeSupplier.get();
                LOGGER.atTrace().log("Executed");
                ThreadContext.remove((String)"AufJms-Msg-Type");
                ThreadContext.remove((String)"AufJms-Correlation-Id");
            });
        }
    }

    private Supplier<InvocationOutcome<?>> newSupplier(final JmsMsg msg, final Executable target) {
        return () -> {
            InvocationOutcome<Supplier> bindingOutcome = InvocationOutcome.invoke(() -> this.binder.bind(target, () -> msg));
            final InvocationOutcome executionOutcome = bindingOutcome.optionalReturned().map(Supplier::get).orElseGet(() -> InvocationOutcome.thrown(bindingOutcome.getThrown()));
            Optional.ofNullable(target.executionConsumer()).ifPresent(postExecution -> {
                LOGGER.atTrace().log("Executing execution consumer");
                postExecution.accept(new ExecutedInstance(){

                    @Override
                    public InvocationOutcome<?> getOutcome() {
                        return executionOutcome;
                    }

                    @Override
                    public JmsMsg getMsg() {
                        return msg;
                    }

                    @Override
                    public Executable getInstance() {
                        return target;
                    }
                });
                LOGGER.atTrace().log("Executed execution consumer");
            });
            LOGGER.atTrace().log("Replying");
            Destination replyTo = msg.replyTo();
            if (replyTo == null) {
                LOGGER.atTrace().log("No replyTo on {}", (Object)msg.correlationId());
                return executionOutcome;
            }
            if (executionOutcome.hasThrown()) {
                LOGGER.atTrace().log("Execution thrown, skipping reply on {}", (Object)msg.correlationId());
                return executionOutcome;
            }
            this.dispatchFn.send(new JmsDispatch(executionOutcome, replyTo){
                final List<?> bodyValues;
                final AtDestination at;
                {
                    this.bodyValues = invocationOutcome.getReturned() != null ? List.of(invocationOutcome.getReturned()) : List.of();
                    this.at = AtDestinationRecord.from(destination);
                }

                @Override
                public AtDestination at() {
                    return this.at;
                }

                @Override
                public String type() {
                    return msg.type();
                }

                @Override
                public String correlationId() {
                    return msg.correlationId();
                }

                @Override
                public List<?> bodyValues() {
                    return this.bodyValues;
                }
            });
            return executionOutcome;
        };
    }
}

