/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.Objects;
import java.util.Set;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.endpoint.ExecutableBinder;
import me.ehp246.aufjms.api.endpoint.ExecutorProvider;
import me.ehp246.aufjms.api.endpoint.InboundEndpoint;
import me.ehp246.aufjms.api.jms.ConnectionFactoryProvider;
import me.ehp246.aufjms.api.jms.DestinationType;
import me.ehp246.aufjms.core.endpoint.DefaultInvokableDispatcher;
import me.ehp246.aufjms.core.jms.AtDestinationRecord;
import me.ehp246.aufjms.core.util.OneUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.MessageListenerContainer;

public final class InboundListenerConfigurer
implements JmsListenerConfigurer {
    private static final Logger LOGGER = LogManager.getLogger(InboundListenerConfigurer.class);
    private final Set<InboundEndpoint> endpoints;
    private final ExecutorProvider executorProvider;
    private final ExecutableBinder binder;
    private final ConnectionFactoryProvider cfProvider;
    private final JmsDispatchFnProvider dispathFnProvider;

    public InboundListenerConfigurer(ConnectionFactoryProvider cfProvider, Set<InboundEndpoint> endpoints, ExecutorProvider executorProvider, ExecutableBinder binder, JmsDispatchFnProvider dispathFnProvider) {
        this.cfProvider = Objects.requireNonNull(cfProvider);
        this.endpoints = endpoints;
        this.executorProvider = executorProvider;
        this.binder = binder;
        this.dispathFnProvider = dispathFnProvider;
    }

    public void configureJmsListeners(JmsListenerEndpointRegistrar registrar) {
        DefaultJmsListenerContainerFactory listenerContainerFactory = this.jmsListenerContainerFactory(null);
        this.endpoints.stream().forEach(endpoint -> {
            LOGGER.atDebug().log("Registering '{}' endpoint at {} on {}", (Object)endpoint.name(), (Object)endpoint.at().name(), (Object)endpoint.connectionFactory());
            DefaultInvokableDispatcher dispatcher = new DefaultInvokableDispatcher(endpoint.resolver(), this.binder, this.executorProvider.get(endpoint.concurrency()), this.dispathFnProvider.get(endpoint.connectionFactory()));
            registrar.registerEndpoint(new JmsListenerEndpoint((InboundEndpoint)endpoint, dispatcher){
                private final /* synthetic */ InboundEndpoint val$endpoint;
                private final /* synthetic */ DefaultInvokableDispatcher val$dispatcher;
                {
                    this.val$endpoint = inboundEndpoint;
                    this.val$dispatcher = defaultInvokableDispatcher;
                }

                public void setupListenerContainer(MessageListenerContainer listenerContainer) {
                    AbstractMessageListenerContainer container = (AbstractMessageListenerContainer)listenerContainer;
                    container.setBeanName(OneUtil.hasValue(this.val$endpoint.name()) ? this.val$endpoint.name() : this.val$endpoint.at().name());
                    container.setAutoStartup(this.val$endpoint.autoStartup());
                    container.setDestinationName(this.val$endpoint.at().name());
                    if (this.val$endpoint.at().type() == DestinationType.TOPIC) {
                        container.setSubscriptionName(this.val$endpoint.subscriptionName());
                        container.setSubscriptionDurable(this.val$endpoint.durable());
                        container.setSubscriptionShared(this.val$endpoint.shared());
                    }
                    container.setDestinationResolver((session, name, topic) -> ((AtDestinationRecord)this.val$endpoint.at()).jmsDestination(session));
                    container.setupMessageListener((Object)this.val$dispatcher);
                }

                public String getId() {
                    return this.val$endpoint.name();
                }
            }, (JmsListenerContainerFactory)listenerContainerFactory);
        });
    }

    private DefaultJmsListenerContainerFactory jmsListenerContainerFactory(String cfName) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(this.cfProvider.get(cfName));
        factory.setSessionTransacted(Boolean.valueOf(true));
        factory.setSessionAcknowledgeMode(Integer.valueOf(2));
        return factory;
    }
}

