/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import me.ehp246.aufjms.api.jms.AtDestination;
import me.ehp246.aufjms.api.jms.DestinationType;
import me.ehp246.aufjms.core.jms.AtQueueRecord;
import me.ehp246.aufjms.core.jms.AtTopicRecord;

public class AtDestinationRecord
implements AtDestination {
    private final String name;
    private final DestinationType type;

    public AtDestinationRecord(AtDestination at) {
        this.name = at.name();
        this.type = at.type();
    }

    public AtDestinationRecord(String name, DestinationType type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DestinationType type() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.type() == DestinationType.QUEUE ? "queue://" : "topic://") + this.name;
    }

    public Destination jmsDestination(Session session) {
        try {
            return this.type == DestinationType.QUEUE ? session.createQueue(this.name) : session.createTopic(this.name);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public static AtDestination from(Destination replyTo) {
        try {
            return replyTo instanceof Queue ? new AtQueueRecord(((Queue)replyTo).getQueueName()) : new AtTopicRecord(((Topic)replyTo).getTopicName());
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }
}

