/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.reflection;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public final class EnabledScanner {
    private final Class<? extends Annotation> enabler;
    private final Class<? extends Annotation> enablee;
    private final AnnotationMetadata metadata;

    public EnabledScanner(Class<? extends Annotation> enabler, Class<? extends Annotation> enablee, AnnotationMetadata metaData) {
        this.enabler = enabler;
        this.enablee = enablee;
        this.metadata = metaData;
    }

    public Stream<BeanDefinition> perform() {
        Map enablerAttributes = this.metadata.getAnnotationAttributes(this.enabler.getCanonicalName());
        if (enablerAttributes == null) {
            return Stream.ofNullable(null);
        }
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return beanDefinition.getMetadata().isInterface();
            }
        };
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.enablee));
        Stream<String> scanThese = null;
        Class[] base = (Class[])enablerAttributes.get("scan");
        if (base.length > 0) {
            scanThese = Stream.of(base).map(baseClass -> baseClass.getPackage().getName()).distinct();
        } else {
            String baseName = this.metadata.getClassName();
            scanThese = Stream.of(baseName.substring(0, baseName.lastIndexOf(".")));
        }
        return scanThese.flatMap(arg_0 -> EnabledScanner.lambda$1(provider, arg_0));
    }

    private static /* synthetic */ Stream lambda$1(1 var0, String packageName) {
        return var0.findCandidateComponents(packageName).stream();
    }
}

