/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.api.jms;

import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jms.Destination;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.jms.JMSSupplier;

public interface JmsMsg {
    public String id();

    public Destination destination();

    public String type();

    public String correlationId();

    public String text();

    public Destination replyTo();

    public String groupId();

    public Integer groupSeq();

    public int deliveryCount();

    public long expiration();

    public Instant timestamp();

    public String invoking();

    public <T> T property(String var1, Class<T> var2);

    public Set<String> propertyNames();

    default public Map<String, Object> propertyMap() {
        TextMessage message = this.message();
        return this.propertyNames().stream().collect(Collectors.toMap(Function.identity(), name -> JMSSupplier.invoke(() -> message.getObjectProperty(name))));
    }

    public TextMessage message();
}

