/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.List;
import java.util.concurrent.Executor;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.endpoint.Executable;
import me.ehp246.aufjms.api.endpoint.ExecutableBinder;
import me.ehp246.aufjms.api.endpoint.ExecutableResolver;
import me.ehp246.aufjms.api.endpoint.FailedInvocation;
import me.ehp246.aufjms.api.endpoint.FailedInvocationInterceptor;
import me.ehp246.aufjms.api.endpoint.InvocationModel;
import me.ehp246.aufjms.api.exception.UnknownTypeException;
import me.ehp246.aufjms.api.jms.AtDestination;
import me.ehp246.aufjms.api.jms.AufJmsContext;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.jms.AtDestinationRecord;
import me.ehp246.aufjms.core.reflection.InvocationOutcome;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.jms.listener.SessionAwareMessageListener;

final class DefaultMsgDispatcher
implements SessionAwareMessageListener<Message> {
    private static final Logger LOGGER = LogManager.getLogger(DefaultMsgDispatcher.class);
    private final Executor executor;
    private final ExecutableResolver executableResolver;
    private final ExecutableBinder binder;
    private final JmsDispatchFn dispatchFn;
    private final FailedInvocationInterceptor failureInterceptor;

    DefaultMsgDispatcher(ExecutableResolver executableResolver, ExecutableBinder binder, Executor executor, JmsDispatchFn dispatchFn, FailedInvocationInterceptor failureInterceptor) {
        this.executableResolver = executableResolver;
        this.binder = binder;
        this.executor = executor;
        this.dispatchFn = dispatchFn;
        this.failureInterceptor = failureInterceptor;
    }

    public void onMessage(Message message, Session session) throws JMSException {
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            try {
                AufJmsContext.set(session);
                ThreadContext.put((String)"AufJms-Type", (String)message.getJMSType());
                ThreadContext.put((String)"AufJms-Correlation-Id", (String)message.getJMSCorrelationID());
                LOGGER.atTrace().log("Dispatching");
                this.dispatch(textMessage);
                LOGGER.atTrace().log("Dispatched");
            }
            catch (Exception e) {
                LOGGER.atTrace().log("Dispatch failed");
                throw e;
            }
            finally {
                ThreadContext.remove((String)"AufJms-Type");
                ThreadContext.remove((String)"AufJms-Correlation-Id");
                AufJmsContext.clearSession();
            }
            return;
        }
        throw new RuntimeException("Un-supported Message: " + message.getJMSCorrelationID());
    }

    private void dispatch(TextMessage message) {
        JmsMsg msg = TextJmsMsg.from(message);
        LOGGER.atTrace().log("Resolving executable");
        Executable executable = this.executableResolver.resolve(msg);
        if (executable == null) {
            throw new UnknownTypeException(msg);
        }
        LOGGER.atTrace().log("Submitting {}", new Supplier[]{() -> executable.method().toString()});
        Runnable runnable = this.newRunnable(msg, executable);
        if (this.executor == null || executable.invocationModel() == InvocationModel.INLINE) {
            runnable.run();
        } else {
            this.executor.execute(() -> {
                try {
                    ThreadContext.put((String)"AufJms-Type", (String)msg.type());
                    ThreadContext.put((String)"AufJms-Correlation-Id", (String)msg.correlationId());
                    runnable.run();
                }
                finally {
                    ThreadContext.remove((String)"AufJms-Type");
                    ThreadContext.remove((String)"AufJms-Correlation-Id");
                }
            });
        }
    }

    private Runnable newRunnable(final JmsMsg msg, Executable target) {
        return () -> {
            final InvocationOutcome<?> executionOutcome = this.binder.bind(target, () -> msg).get();
            Throwable thrown = executionOutcome.thrown();
            if (thrown != null) {
                if (this.failureInterceptor != null) {
                    try {
                        this.failureInterceptor.accept(new FailedInvocation(msg, target, thrown));
                        LOGGER.atTrace().log("Failure interceptor invoked");
                    }
                    catch (Exception e) {
                        Supplier[] supplierArray = new Supplier[1];
                        supplierArray[0] = e::getMessage;
                        LOGGER.atTrace().log("Failure interceptor failed: {}", supplierArray);
                        throw e;
                    }
                    return;
                }
                if (thrown instanceof RuntimeException) {
                    RuntimeException rtEx = (RuntimeException)thrown;
                    throw rtEx;
                }
                throw new RuntimeException(thrown);
            }
            final Destination replyTo = msg.replyTo();
            if (replyTo == null) {
                LOGGER.atTrace().log("No replyTo");
                return;
            }
            if (executionOutcome.hasThrown()) {
                LOGGER.atTrace().log("Execution thrown, skipping reply");
                return;
            }
            LOGGER.atTrace().log("Replying");
            this.dispatchFn.send(new JmsDispatch(){
                final List<?> bodyValues;
                final AtDestination at;
                {
                    this.bodyValues = executionOutcome.returned() != null ? List.of(executionOutcome.returned()) : List.of();
                    this.at = AtDestinationRecord.from(replyTo);
                }

                @Override
                public AtDestination at() {
                    return this.at;
                }

                @Override
                public String type() {
                    return msg.type();
                }

                @Override
                public String correlationId() {
                    return msg.correlationId();
                }

                @Override
                public List<?> bodyValues() {
                    return this.bodyValues;
                }
            });
        };
    }
}

