/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.ehp246.aufjms.api.annotation.EnableForJms;
import me.ehp246.aufjms.api.endpoint.InboundEndpoint;
import me.ehp246.aufjms.core.endpoint.InboundEndpointFactory;
import me.ehp246.aufjms.core.util.OneUtil;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public final class InboundEndpointRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map enablerAttributes = importingClassMetadata.getAnnotationAttributes(EnableForJms.class.getCanonicalName());
        if (enablerAttributes == null) {
            return;
        }
        List<Map> inbounds = Arrays.asList((Map[])enablerAttributes.get("value"));
        for (int i = 0; i < inbounds.size(); ++i) {
            Map inbound = inbounds.get(i);
            GenericBeanDefinition beanDefinition = this.newBeanDefinition(inbound);
            Set<Object> scanThese = null;
            Class[] base = (Class[])inbound.get("scan");
            if (base.length > 0) {
                scanThese = Stream.of(base).map(baseClass -> baseClass.getPackage().getName()).collect(Collectors.toSet());
            } else {
                String baseName = importingClassMetadata.getClassName();
                scanThese = Set.of(baseName.substring(0, baseName.lastIndexOf(".")));
            }
            String beanName = Optional.of(inbound.get("name").toString()).filter(OneUtil::hasValue).orElse(InboundEndpoint.class.getSimpleName() + "@" + i);
            ConstructorArgumentValues constructorArgumentValues = new ConstructorArgumentValues();
            constructorArgumentValues.addGenericArgumentValue((Object)inbound);
            constructorArgumentValues.addGenericArgumentValue(scanThese);
            constructorArgumentValues.addGenericArgumentValue((Object)beanName);
            beanDefinition.setConstructorArgumentValues(constructorArgumentValues);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    private GenericBeanDefinition newBeanDefinition(Map<String, Object> annotationAttributes) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(InboundEndpoint.class);
        beanDefinition.setFactoryBeanName(InboundEndpointFactory.class.getName());
        beanDefinition.setFactoryMethodName("newInstance");
        return beanDefinition;
    }
}

