/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.Objects;
import me.ehp246.aufjms.api.endpoint.Executable;
import me.ehp246.aufjms.api.endpoint.ExecutableResolver;
import me.ehp246.aufjms.api.endpoint.InstanceScope;
import me.ehp246.aufjms.api.endpoint.InvokableResolver;
import me.ehp246.aufjms.api.endpoint.ResolvedInstanceType;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.endpoint.ExecutableRecord;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public final class AutowireCapableExecutableResolver
implements ExecutableResolver {
    private final AutowireCapableBeanFactory autowireCapableBeanFactory;
    private final InvokableResolver typeResolver;

    public AutowireCapableExecutableResolver(AutowireCapableBeanFactory autowireCapableBeanFactory, InvokableResolver resolver) {
        this.autowireCapableBeanFactory = autowireCapableBeanFactory;
        this.typeResolver = resolver;
    }

    @Override
    public Executable resolve(JmsMsg msg) {
        Objects.requireNonNull(msg);
        ResolvedInstanceType registered = this.typeResolver.resolve(msg);
        if (registered == null) {
            return null;
        }
        Object executableInstance = registered.scope().equals((Object)InstanceScope.BEAN) ? this.autowireCapableBeanFactory.getBean(registered.instanceType()) : this.autowireCapableBeanFactory.createBean(registered.instanceType());
        return new ExecutableRecord(executableInstance, registered.method(), registered.invocationModel());
    }
}

