/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.ehp246.aufjms.api.dispatch.InvocationDispatchBuilder;
import me.ehp246.aufjms.api.dispatch.InvocationDispatchConfig;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.reflection.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ByJmsFactory {
    private static final Logger LOGGER = LogManager.getLogger(ByJmsFactory.class);
    private final InvocationDispatchBuilder dispatchProvider;
    private final JmsDispatchFnProvider dispatchFnProvider;

    public ByJmsFactory(JmsDispatchFnProvider dispatchFnProvider, InvocationDispatchBuilder dispatchProvider) {
        this.dispatchProvider = dispatchProvider;
        this.dispatchFnProvider = dispatchFnProvider;
    }

    public <T> T newInstance(Class<T> byJmsInterface, InvocationDispatchConfig jmsDispatchConfig, String connectionFactoryName) {
        LOGGER.atDebug().log("Instantiating {}", (Object)byJmsInterface.getCanonicalName());
        JmsDispatchFn dispatchFn = this.dispatchFnProvider.get(connectionFactoryName);
        int hashCode = new Object().hashCode();
        return (T)Proxy.newProxyInstance(byJmsInterface.getClassLoader(), new Class[]{byJmsInterface}, (proxy, method, args) -> {
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            if (method.getName().equals("hashCode")) {
                return hashCode;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.isDefault()) {
                return MethodHandles.privateLookupIn(byJmsInterface, MethodHandles.lookup()).findSpecial(byJmsInterface, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), byJmsInterface).bindTo(proxy).invokeWithArguments(args);
            }
            JmsDispatch jmsDispatch = this.dispatchProvider.get(new Invocation(){
                private final List<?> asList;
                {
                    this.asList = Collections.unmodifiableList(args == null ? List.of() : Arrays.asList(args));
                }

                @Override
                public Object target() {
                    return proxy;
                }

                @Override
                public Method method() {
                    return method;
                }

                @Override
                public List<?> args() {
                    return this.asList;
                }
            }, jmsDispatchConfig);
            dispatchFn.send(jmsDispatch);
            return null;
        });
    }
}

