/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.time.Duration;
import java.util.Map;
import me.ehp246.aufjms.api.annotation.ByJms;
import me.ehp246.aufjms.api.annotation.EnableByJms;
import me.ehp246.aufjms.api.dispatch.InvocationDispatchConfig;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.DestinationType;
import me.ehp246.aufjms.core.dispatch.ByJmsFactory;
import me.ehp246.aufjms.core.dispatch.DefaultDispatchFnProvider;
import me.ehp246.aufjms.core.reflection.EnabledScanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public final class ByJmsRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger LOGGER = LogManager.getLogger(ByJmsRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        LOGGER.atTrace().log("Scanning for {}", (Object)ByJms.class.getCanonicalName());
        new EnabledScanner(EnableByJms.class, ByJms.class, metadata).perform().forEach(beanDefinition -> {
            Class<?> proxyInterface;
            try {
                proxyInterface = Class.forName(beanDefinition.getBeanClassName());
            }
            catch (ClassNotFoundException ignored) {
                throw new RuntimeException("Class scanning started this. Should not happen.");
            }
            LOGGER.atTrace().log("Defining {}", (Object)beanDefinition.getBeanClassName());
            String name = proxyInterface.getAnnotation(ByJms.class).name();
            registry.registerBeanDefinition(name.equals("") ? proxyInterface.getSimpleName() : name, this.getProxyBeanDefinition(metadata.getAnnotationAttributes(EnableByJms.class.getCanonicalName()), proxyInterface));
        });
        Map enablerAttributes = metadata.getAnnotationAttributes(EnableByJms.class.getCanonicalName());
        String[] fns = (String[])enablerAttributes.get("dispatchFns");
        if (fns.length == 0) {
            return;
        }
        LOGGER.atTrace().log("Defining {} on {}", (Object)JmsDispatchFn.class.getSimpleName(), (Object)fns);
        for (int i = 0; i < fns.length; ++i) {
            registry.registerBeanDefinition(JmsDispatchFn.class.getSimpleName() + "-" + i, this.getFnBeanDefinition(fns[i]));
        }
    }

    private BeanDefinition getFnBeanDefinition(String name) {
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addGenericArgumentValue((Object)name);
        GenericBeanDefinition proxyBeanDefinition = new GenericBeanDefinition();
        proxyBeanDefinition.setBeanClass(JmsDispatchFn.class);
        proxyBeanDefinition.setConstructorArgumentValues(args);
        proxyBeanDefinition.setFactoryBeanName(DefaultDispatchFnProvider.class.getName());
        proxyBeanDefinition.setFactoryMethodName("get");
        return proxyBeanDefinition;
    }

    private BeanDefinition getProxyBeanDefinition(Map<String, Object> map, Class<?> proxyInterface) {
        At replyTo;
        ByJms byJms = proxyInterface.getAnnotation(ByJms.class);
        final At destination = byJms.value().type() == DestinationType.QUEUE ? At.toQueue(byJms.value().value()) : At.toTopic(byJms.value().value());
        At at = replyTo = byJms.replyTo().type() == DestinationType.QUEUE ? At.toQueue(byJms.replyTo().value()) : At.toTopic(byJms.replyTo().value());
        final String ttl = byJms.ttl().equals("") ? (map.get("ttl").toString().equals("") ? Duration.ZERO.toString() : map.get("ttl").toString()) : byJms.ttl();
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addGenericArgumentValue(proxyInterface);
        args.addGenericArgumentValue((Object)new InvocationDispatchConfig(){

            @Override
            public String ttl() {
                return ttl;
            }

            @Override
            public At to() {
                return destination;
            }

            @Override
            public At replyTo() {
                return replyTo;
            }
        });
        args.addGenericArgumentValue((Object)byJms.connectionFactory());
        GenericBeanDefinition proxyBeanDefinition = new GenericBeanDefinition();
        proxyBeanDefinition.setBeanClass(proxyInterface);
        proxyBeanDefinition.setConstructorArgumentValues(args);
        proxyBeanDefinition.setFactoryBeanName(ByJmsFactory.class.getName());
        proxyBeanDefinition.setFactoryMethodName("newInstance");
        return proxyBeanDefinition;
    }
}

