/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.concurrent.Executor;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.endpoint.Executable;
import me.ehp246.aufjms.api.endpoint.ExecutableBinder;
import me.ehp246.aufjms.api.endpoint.ExecutableResolver;
import me.ehp246.aufjms.api.endpoint.InvocationModel;
import me.ehp246.aufjms.api.exception.UnknownTypeException;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.AufJmsContext;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.Log4jContext;
import me.ehp246.aufjms.core.endpoint.CompletedInvocationRecord;
import me.ehp246.aufjms.core.endpoint.FailedInvocationRecord;
import me.ehp246.aufjms.core.endpoint.InvocationListenersSupplier;
import me.ehp246.aufjms.core.reflection.InvocationOutcome;
import me.ehp246.aufjms.core.util.OneUtil;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.jms.listener.SessionAwareMessageListener;

final class InboundMsgConsumer
implements SessionAwareMessageListener<Message> {
    private static final Logger LOGGER = LogManager.getLogger(InboundMsgConsumer.class);
    private final Executor executor;
    private final ExecutableResolver executableResolver;
    private final ExecutableBinder binder;
    private final JmsDispatchFn dispatchFn;
    private final InvocationListenersSupplier invocationListener;

    InboundMsgConsumer(ExecutableResolver executableResolver, ExecutableBinder binder, Executor executor, JmsDispatchFn dispatchFn, InvocationListenersSupplier invocationListener) {
        this.executableResolver = executableResolver;
        this.binder = binder;
        this.executor = executor;
        this.dispatchFn = dispatchFn;
        this.invocationListener = invocationListener;
    }

    public void onMessage(Message message, Session session) throws JMSException {
        if (!(message instanceof TextMessage)) {
            throw new IllegalArgumentException("Un-supported message type of " + message.getJMSCorrelationID());
        }
        TextMessage textMessage = (TextMessage)message;
        JmsMsg msg = TextJmsMsg.from(textMessage);
        try {
            AufJmsContext.set(session);
            Log4jContext.set(msg);
            LOGGER.atTrace().log("Consuming");
            this.dispatch(msg, session);
            LOGGER.atTrace().log("Consumed");
        }
        catch (Exception e) {
            LOGGER.atError().log("Message failed: {}", (Object)e.getMessage());
            throw e;
        }
        finally {
            Log4jContext.clear();
            AufJmsContext.clearSession();
        }
    }

    private void dispatch(JmsMsg msg, Session session) {
        LOGGER.atTrace().log("Resolving executable");
        Executable executable = this.executableResolver.resolve(msg);
        if (executable == null) {
            throw new UnknownTypeException(msg);
        }
        LOGGER.atTrace().log("Submitting {}", new Supplier[]{() -> executable.method().toString()});
        Runnable runnable = this.newRunnable(msg, executable);
        if (this.executor == null || executable.invocationModel() == InvocationModel.INLINE) {
            runnable.run();
        } else {
            this.executor.execute(() -> {
                try {
                    AufJmsContext.set(session);
                    Log4jContext.set(msg);
                    runnable.run();
                }
                finally {
                    Log4jContext.clear();
                    AufJmsContext.clearSession();
                }
            });
        }
    }

    private Runnable newRunnable(final JmsMsg msg, final Executable target) {
        return new Runnable(){

            @Override
            public void run() {
                Destination replyTo;
                InvocationOutcome<?> executionOutcome = InboundMsgConsumer.this.binder.bind(target, () -> msg).get();
                Throwable thrown = executionOutcome.thrown();
                if (thrown != null) {
                    if (InboundMsgConsumer.this.invocationListener.failedInterceptor() == null) {
                        throw OneUtil.toRuntime(thrown);
                    }
                    LOGGER.atTrace().log("Executing failed interceptor");
                    try {
                        InboundMsgConsumer.this.invocationListener.failedInterceptor().accept(new FailedInvocationRecord(msg, target, thrown));
                        LOGGER.atTrace().log("Failure interceptor invoked");
                        return;
                    }
                    catch (Exception e) {
                        Supplier[] supplierArray = new Supplier[1];
                        supplierArray[0] = e::getMessage;
                        LOGGER.atTrace().log("Failure interceptor failed: {}", supplierArray);
                        throw OneUtil.toRuntime(e);
                    }
                }
                if (InboundMsgConsumer.this.invocationListener.completedConsumer() != null) {
                    LOGGER.atTrace().log("Executing completed consumer");
                    try {
                        InboundMsgConsumer.this.invocationListener.completedConsumer().accept(new CompletedInvocationRecord(msg, target, executionOutcome.returned()));
                        LOGGER.atTrace().log("Completed consumer invoked");
                    }
                    catch (Exception e) {
                        LOGGER.atTrace().log("Completed consumer failed: {}", (Object)e.getMessage());
                        throw OneUtil.toRuntime(e);
                    }
                }
                if ((replyTo = msg.replyTo()) == null) {
                    LOGGER.atTrace().log("No replyTo");
                    return;
                }
                LOGGER.atTrace().log("Replying");
                InboundMsgConsumer.this.dispatchFn.send(JmsDispatch.toDispatch(InboundMsgConsumer.toAt(replyTo), msg.type(), executionOutcome.returned(), msg.correlationId()));
                LOGGER.atTrace().log("Replied");
            }
        };
    }

    private static At toAt(Destination replyTo) {
        try {
            return replyTo instanceof Queue ? At.toQueue(((Queue)replyTo).getQueueName()) : At.toTopic(((Topic)replyTo).getTopicName());
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }
}

