/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Proxy;
import java.time.Duration;
import me.ehp246.aufjms.api.annotation.ByJms;
import me.ehp246.aufjms.api.dispatch.ByJmsConfig;
import me.ehp246.aufjms.api.dispatch.EnableByJmsConfig;
import me.ehp246.aufjms.api.dispatch.InvocationDispatchBuilder;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.AtQueue;
import me.ehp246.aufjms.api.jms.DestinationType;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.util.OneUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ByJmsProxyFactory {
    private static final Logger LOGGER = LogManager.getLogger(ByJmsProxyFactory.class);
    private final InvocationDispatchBuilder dispatchBuilder;
    private final JmsDispatchFnProvider dispatchFnProvider;
    private final PropertyResolver propertyResolver;
    private final EnableByJmsConfig enableByJmsConfig;

    public ByJmsProxyFactory(EnableByJmsConfig enableByJmsConfig, JmsDispatchFnProvider dispatchFnProvider, InvocationDispatchBuilder dispatchProvider, PropertyResolver propertyResolver) {
        this.enableByJmsConfig = enableByJmsConfig;
        this.dispatchBuilder = dispatchProvider;
        this.dispatchFnProvider = dispatchFnProvider;
        this.propertyResolver = propertyResolver;
    }

    public <T> T newInstance(Class<T> proxyInterface) {
        AtQueue replyTo;
        LOGGER.atDebug().log("Instantiating {}", (Object)proxyInterface.getCanonicalName());
        ByJms byJms = proxyInterface.getAnnotation(ByJms.class);
        String toName = this.propertyResolver.resolve(byJms.value().value());
        if (!OneUtil.hasValue(toName)) {
            throw new IllegalArgumentException("Un-supported To: '" + toName + "'");
        }
        At destination = byJms.value().type() == DestinationType.QUEUE ? At.toQueue(toName) : At.toTopic(toName);
        String replyToName = this.propertyResolver.resolve(byJms.replyTo().value());
        At at = OneUtil.hasValue(replyToName) ? (byJms.replyTo().type() == DestinationType.QUEUE ? At.toQueue(replyToName) : At.toTopic(replyToName)) : (replyTo = null);
        Duration ttl = Duration.parse(this.propertyResolver.resolve(byJms.ttl().equals("") ? (this.enableByJmsConfig.ttl().equals("") ? Duration.ZERO.toString() : this.enableByJmsConfig.ttl()) : byJms.ttl()));
        ByJmsConfig byJmsConfig = new ByJmsConfig(destination, replyTo, ttl, null, byJms.connectionFactory());
        JmsDispatchFn dispatchFn = this.dispatchFnProvider.get(byJms.connectionFactory());
        int hashCode = new Object().hashCode();
        return (T)Proxy.newProxyInstance(proxyInterface.getClassLoader(), new Class[]{proxyInterface}, (proxy, method, args) -> {
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            if (method.getName().equals("hashCode")) {
                return hashCode;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.isDefault()) {
                return MethodHandles.privateLookupIn(proxyInterface, MethodHandles.lookup()).findSpecial(proxyInterface, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), proxyInterface).bindTo(proxy).invokeWithArguments(args);
            }
            JmsDispatch jmsDispatch = this.dispatchBuilder.get(proxy, method, args, byJmsConfig);
            dispatchFn.send(jmsDispatch);
            return null;
        });
    }
}

