/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.util.Arrays;
import java.util.Map;
import me.ehp246.aufjms.api.annotation.ByJms;
import me.ehp246.aufjms.api.annotation.EnableByJms;
import me.ehp246.aufjms.api.dispatch.EnableByJmsConfig;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.core.dispatch.ByJmsBeanFactory;
import me.ehp246.aufjms.core.dispatch.DefaultDispatchFnProvider;
import me.ehp246.aufjms.core.dispatch.EnableByJmsBeanFactory;
import me.ehp246.aufjms.core.reflection.EnabledScanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public final class EnableByJmsRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger LOGGER = LogManager.getLogger(EnableByJmsRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map enableMap = metadata.getAnnotationAttributes(EnableByJms.class.getCanonicalName());
        LOGGER.atTrace().log("Registering {} as '{}'", (Object)EnableByJmsConfig.class.getCanonicalName(), (Object)EnableByJmsConfig.class.getSimpleName());
        registry.registerBeanDefinition(EnableByJmsConfig.class.getSimpleName(), this.getAppConfigBeanDefinition(enableMap));
        LOGGER.atTrace().log("Scanning for {}", (Object)ByJms.class.getCanonicalName());
        new EnabledScanner(EnableByJms.class, ByJms.class, metadata).perform().forEach(beanDefinition -> {
            Class<?> proxyInterface;
            try {
                proxyInterface = Class.forName(beanDefinition.getBeanClassName());
            }
            catch (ClassNotFoundException ignored) {
                throw new RuntimeException("Class scanning started this. Should not happen.");
            }
            LOGGER.atTrace().log("Defining {}", (Object)beanDefinition.getBeanClassName());
            String name = proxyInterface.getAnnotation(ByJms.class).name();
            registry.registerBeanDefinition(name.equals("") ? proxyInterface.getSimpleName() : name, this.getProxyBeanDefinition(proxyInterface));
        });
        Map enablerAttributes = metadata.getAnnotationAttributes(EnableByJms.class.getCanonicalName());
        String[] fns = (String[])enablerAttributes.get("dispatchFns");
        if (fns.length == 0) {
            return;
        }
        for (int i = 0; i < fns.length; ++i) {
            String fnBeanName = JmsDispatchFn.class.getSimpleName() + "-" + i;
            LOGGER.atTrace().log("Defining '{}' on '{}'", (Object)fnBeanName, (Object)fns[i]);
            registry.registerBeanDefinition(fnBeanName, this.getFnBeanDefinition(fns[i]));
        }
    }

    private BeanDefinition getAppConfigBeanDefinition(Map<String, Object> map) {
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addGenericArgumentValue(Arrays.asList((Class[])map.get("scan")));
        args.addGenericArgumentValue(map.get("ttl"));
        args.addGenericArgumentValue(Arrays.asList((String[])map.get("dispatchFns")));
        GenericBeanDefinition proxyBeanDefinition = new GenericBeanDefinition();
        proxyBeanDefinition.setBeanClass(EnableByJmsConfig.class);
        proxyBeanDefinition.setConstructorArgumentValues(args);
        proxyBeanDefinition.setFactoryBeanName(EnableByJmsBeanFactory.class.getName());
        proxyBeanDefinition.setFactoryMethodName("enableByJmsConfig");
        return proxyBeanDefinition;
    }

    private BeanDefinition getFnBeanDefinition(String name) {
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addGenericArgumentValue((Object)name);
        GenericBeanDefinition proxyBeanDefinition = new GenericBeanDefinition();
        proxyBeanDefinition.setBeanClass(JmsDispatchFn.class);
        proxyBeanDefinition.setConstructorArgumentValues(args);
        proxyBeanDefinition.setFactoryBeanName(DefaultDispatchFnProvider.class.getName());
        proxyBeanDefinition.setFactoryMethodName("get");
        return proxyBeanDefinition;
    }

    private BeanDefinition getProxyBeanDefinition(Class<?> proxyInterface) {
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addGenericArgumentValue(proxyInterface);
        GenericBeanDefinition proxyBeanDefinition = new GenericBeanDefinition();
        proxyBeanDefinition.setBeanClass(proxyInterface);
        proxyBeanDefinition.setConstructorArgumentValues(args);
        proxyBeanDefinition.setFactoryBeanName(ByJmsBeanFactory.class.getName());
        proxyBeanDefinition.setFactoryMethodName("newByJmsProxy");
        return proxyBeanDefinition;
    }
}

