/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.ehp246.aufjms.api.endpoint.CompletedInvocationConsumer;
import me.ehp246.aufjms.api.endpoint.FailedInvocationInterceptor;
import me.ehp246.aufjms.api.endpoint.InboundEndpoint;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.DestinationType;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.endpoint.AutowireCapableExecutableResolver;
import me.ehp246.aufjms.core.endpoint.DefaultInvokableResolver;
import me.ehp246.aufjms.core.endpoint.InboundEndpointRecord;
import me.ehp246.aufjms.core.util.OneUtil;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public final class InboundEndpointFactory {
    private final PropertyResolver propertyResolver;
    private final AutowireCapableBeanFactory autowireCapableBeanFactory;

    public InboundEndpointFactory(AutowireCapableBeanFactory autowireCapableBeanFactory, PropertyResolver propertyResolver) {
        this.autowireCapableBeanFactory = autowireCapableBeanFactory;
        this.propertyResolver = propertyResolver;
    }

    public InboundEndpoint newInstance(Map<String, Object> inboundAttributes, Set<String> scanPackages, String beanName) {
        Map fromAttribute = (Map)inboundAttributes.get("value");
        Map subAttribute = (Map)fromAttribute.get("sub");
        String atName = this.propertyResolver.resolve(fromAttribute.get("value").toString());
        DestinationType atType = (DestinationType)((Object)fromAttribute.get("type"));
        InboundEndpointRecord.From from = new InboundEndpointRecord.From(atType == DestinationType.TOPIC ? At.toTopic(atName) : At.toQueue(atName), this.propertyResolver.resolve(fromAttribute.get("selector").toString()), new InboundEndpointRecord.Sub(this.propertyResolver.resolve(subAttribute.get("value").toString()), (Boolean)subAttribute.get("shared"), (Boolean)subAttribute.get("durable")));
        int concurrency = Integer.parseInt(this.propertyResolver.resolve(inboundAttributes.get("concurrency").toString()));
        boolean autoStartup = Boolean.parseBoolean(this.propertyResolver.resolve(inboundAttributes.get("autoStartup").toString()));
        String connectionFactory = this.propertyResolver.resolve(inboundAttributes.get("connectionFactory").toString());
        AutowireCapableExecutableResolver resolver = new AutowireCapableExecutableResolver(this.autowireCapableBeanFactory, DefaultInvokableResolver.registeryFrom(scanPackages));
        FailedInvocationInterceptor failedInterceptor = Optional.ofNullable(inboundAttributes.get("failedInvocationInterceptor").toString()).map(this.propertyResolver::resolve).filter(OneUtil::hasValue).map(name -> (FailedInvocationInterceptor)this.autowireCapableBeanFactory.getBean(name, FailedInvocationInterceptor.class)).orElse(null);
        CompletedInvocationConsumer completedConsumer = Optional.ofNullable(inboundAttributes.get("completedInvocationConsumer").toString()).map(this.propertyResolver::resolve).filter(OneUtil::hasValue).map(name -> (CompletedInvocationConsumer)this.autowireCapableBeanFactory.getBean(name, CompletedInvocationConsumer.class)).orElse(null);
        return new InboundEndpointRecord(from, resolver, concurrency, beanName, autoStartup, connectionFactory, completedConsumer, failedInterceptor);
    }
}

