/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ReflectingType<T> {
    private final Class<T> type;

    public ReflectingType(Class<T> type) {
        this.type = type;
    }

    public static <T> ReflectingType<T> reflect(Class<T> type) {
        return new ReflectingType<T>(type);
    }

    public Method findMethod(String name) {
        try {
            return this.type.getMethod(name, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Method findMethod(String name, Class<?> ... parameters) {
        try {
            return this.type.getMethod(name, parameters);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<Method> findMethods(String name) {
        return Stream.of(this.type.getMethods()).filter(method -> method.getName().equals(name)).collect(Collectors.toList());
    }

    public List<Method> findMethods(Class<? extends Annotation> annotationClass) {
        return Stream.of(this.type.getMethods()).filter(method -> method.getDeclaredAnnotation(annotationClass) != null).collect(Collectors.toList());
    }

    public Class<T> getType() {
        return this.type;
    }

    public <A extends Annotation> Optional<A> findOnType(Class<A> annotationType) {
        return Optional.ofNullable(this.type.getAnnotation(annotationType));
    }
}

