/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import me.ehp246.aufjms.api.annotation.OfCorrelationId;
import me.ehp246.aufjms.api.annotation.OfDelay;
import me.ehp246.aufjms.api.annotation.OfProperty;
import me.ehp246.aufjms.api.annotation.OfTtl;
import me.ehp246.aufjms.api.annotation.OfType;
import me.ehp246.aufjms.api.dispatch.ByJmsConfig;
import me.ehp246.aufjms.api.dispatch.InvocationDispatchBuilder;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.AtQueue;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.reflection.AnnotatedArgument;
import me.ehp246.aufjms.core.reflection.DefaultProxyInvocation;
import me.ehp246.aufjms.core.reflection.ReflectedArgument;
import me.ehp246.aufjms.core.util.OneUtil;

public final class DefaultInvocationDispatchBuilder
implements InvocationDispatchBuilder {
    private static final Set<Class<? extends Annotation>> PARAMETER_ANNOTATIONS = Set.of(OfType.class, OfProperty.class, OfTtl.class, OfDelay.class, OfCorrelationId.class);
    private final PropertyResolver propertyResolver;

    public DefaultInvocationDispatchBuilder(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    @Override
    public JmsDispatch get(Object proxy, Method method, Object[] args, final ByJmsConfig config) {
        DefaultProxyInvocation proxyInvocation = new DefaultProxyInvocation(method.getDeclaringClass(), proxy, method, args);
        final At destination = config.to() instanceof AtQueue ? At.toQueue(config.to().name()) : At.toTopic(config.to().name());
        final At replyTo = Optional.ofNullable(config.replyTo()).map(at -> at instanceof AtQueue ? At.toQueue(at.name()) : At.toTopic(at.name())).orElse(null);
        final String type = proxyInvocation.resolveAnnotatedValue(OfType.class, arg -> arg.argument() != null ? arg.argument().toString() : (((OfType)arg.annotation()).value().isBlank() ? null : ((OfType)arg.annotation()).value()), ofMethod -> ofMethod.value().isBlank() ? OneUtil.firstUpper(proxyInvocation.getMethodName()) : ofMethod.value(), ofClass -> ofClass.value().isBlank() ? proxyInvocation.getDeclaringClassSimpleName() : ofClass.value(), () -> OneUtil.firstUpper(proxyInvocation.getMethodName()));
        final HashMap properties = new HashMap();
        proxyInvocation.streamOfAnnotatedArguments(OfProperty.class).forEach(new Consumer<AnnotatedArgument<OfProperty>>(){

            @Override
            public void accept(AnnotatedArgument<OfProperty> annoArg) {
                String key = annoArg.annotation().value();
                Object value = annoArg.argument();
                if (!OneUtil.hasValue(key) && !annoArg.parameter().getType().isAssignableFrom(Map.class)) {
                    throw new RuntimeException("Un-defined property name on parameter " + annoArg.parameter());
                }
                if (annoArg.parameter().getType().isAssignableFrom(Map.class) && value == null) {
                    return;
                }
                this.newValue(key, value);
            }

            private void newValue(String key, Object newValue) {
                if (newValue instanceof Map) {
                    properties.putAll((Map)newValue);
                    return;
                }
                properties.put(key.toString(), newValue);
            }
        });
        final String delaySpecified = Optional.ofNullable(proxyInvocation.resolveAnnotatedValue(OfDelay.class, arg -> arg.argument() != null ? arg.argument().toString() : (((OfDelay)arg.annotation()).value().isBlank() ? null : this.propertyResolver.resolve(((OfDelay)arg.annotation()).value())), ofDelay -> this.propertyResolver.resolve(ofDelay.value()), ofDelay -> this.propertyResolver.resolve(ofDelay.value()), () -> null)).orElse(null);
        final String ttlSpecified = Optional.ofNullable(proxyInvocation.resolveAnnotatedValue(OfTtl.class, arg -> arg.argument() != null ? arg.argument().toString() : (((OfTtl)arg.annotation()).value().isBlank() ? null : ((OfTtl)arg.annotation()).value()), OfTtl::value, a -> null, () -> null)).map(this.propertyResolver::resolve).orElse(null);
        final String correlId = proxyInvocation.firstArgumentAnnotationOf(OfCorrelationId.class, annoArg -> Optional.ofNullable(annoArg.argument()).map(Object::toString).orElse(null), () -> UUID.randomUUID().toString());
        final ReflectedArgument bodyArg = proxyInvocation.filterPayloadArgs(PARAMETER_ANNOTATIONS).stream().findFirst().orElseGet(() -> new ReflectedArgument(null, null, null));
        return new JmsDispatch(){
            private final Duration ttl;
            private final Duration delay;
            {
                Duration duration = ttlSpecified == null ? config.ttl() : (this.ttl = OneUtil.hasValue(ttlSpecified) ? Duration.parse(ttlSpecified) : null);
                this.delay = delaySpecified == null ? config.delay() : (OneUtil.hasValue(delaySpecified) ? Duration.parse(delaySpecified) : null);
            }

            @Override
            public At to() {
                return destination;
            }

            @Override
            public String type() {
                return type;
            }

            @Override
            public String correlationId() {
                return correlId;
            }

            @Override
            public Object body() {
                return bodyArg.argument();
            }

            @Override
            public JmsDispatch.BodyAs bodyAs() {
                return () -> bodyArg.parameter().getType();
            }

            @Override
            public At replyTo() {
                return replyTo;
            }

            @Override
            public Duration ttl() {
                return this.ttl;
            }

            @Override
            public Map<String, Object> properties() {
                return properties;
            }

            @Override
            public Duration delay() {
                return this.delay;
            }
        };
    }
}

