/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import me.ehp246.aufjms.api.dispatch.DispatchListener;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.jms.JmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public final class DispatchLogger
implements DispatchListener.OnDispatch,
DispatchListener.PreSend,
DispatchListener.PostSend,
DispatchListener.OnException {
    private static final Logger LOGGER = LogManager.getLogger((String)"me.ehp246.aufjms.dispatchLogger");

    @Override
    public void onDispatch(JmsDispatch dispatch) {
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = dispatch::to;
        supplierArray[1] = dispatch::type;
        supplierArray[2] = dispatch::correlationId;
        LOGGER.atInfo().log("Sending {}, {}, {}", supplierArray);
    }

    @Override
    public void preSend(JmsDispatch dispatch, JmsMsg msg) {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> dispatch.body() == null ? null : dispatch.bodyAs().type();
        supplierArray[1] = msg::text;
        LOGGER.atTrace().log("Sending {}, {}", supplierArray);
    }

    @Override
    public void postSend(JmsDispatch dispatch, JmsMsg msg) {
        LOGGER.atInfo().log("Sent");
    }

    @Override
    public void onException(JmsDispatch dispatch, JmsMsg msg, Exception e) {
        LOGGER.atError().withThrowable((Throwable)e).log("Failed: {}", (Object)e.getMessage());
    }
}

