/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.ehp246.aufjms.api.annotation.ForJmsType;
import me.ehp246.aufjms.api.annotation.Invoking;
import me.ehp246.aufjms.api.endpoint.InstanceScope;
import me.ehp246.aufjms.api.endpoint.InvocableType;
import me.ehp246.aufjms.api.endpoint.InvocableTypeDefinition;
import me.ehp246.aufjms.api.endpoint.InvocableTypeRegistry;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.reflection.ReflectingType;
import me.ehp246.aufjms.core.util.OneUtil;
import me.ehp246.aufjms.core.util.StreamOf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

final class DefaultInvocableRegistry
implements InvocableTypeRegistry {
    private static final Logger LOGGER = LogManager.getLogger(DefaultInvocableRegistry.class);
    private final Map<String, InvocableTypeDefinition> registeredInvokables = new ConcurrentHashMap<String, InvocableTypeDefinition>();
    private final Map<Class<?>, Map<String, Method>> registeredMethods = new ConcurrentHashMap();

    DefaultInvocableRegistry() {
    }

    public DefaultInvocableRegistry register(Stream<InvocableTypeDefinition> invokingDefinitions) {
        invokingDefinitions.forEach(this::register);
        return this;
    }

    @Override
    public void register(InvocableTypeDefinition invokingDefinition) {
        invokingDefinition.msgTypes().forEach(type -> {
            InvocableTypeDefinition registered = this.registeredInvokables.putIfAbsent((String)type, invokingDefinition);
            if (registered != null) {
                throw new IllegalArgumentException("Duplicate type " + type + " from " + registered.type());
            }
            this.registeredMethods.put(invokingDefinition.type(), invokingDefinition.methods());
        });
    }

    @Override
    public List<InvocableTypeDefinition> registered() {
        return this.registeredInvokables.values().stream().collect(Collectors.toList());
    }

    @Override
    public InvocableType resolve(JmsMsg msg) {
        String msgType = OneUtil.toString(Objects.requireNonNull(msg).type(), "");
        InvocableTypeDefinition definition = this.registeredInvokables.entrySet().stream().filter(e -> msgType.matches((String)e.getKey())).findAny().map(Map.Entry::getValue).orElse(null);
        if (definition == null) {
            LOGGER.atTrace().log("Type {} not found", (Object)msgType);
            return null;
        }
        String invoking = msg.invoking();
        invoking = invoking != null ? invoking.strip() : "";
        Method method = this.registeredMethods.get(definition.type()).get(invoking);
        if (method == null) {
            LOGGER.atTrace().log("Method {} not found", (Object)invoking);
            return null;
        }
        return new InvocableType(definition.type(), method, definition.scope(), definition.model());
    }

    public static DefaultInvocableRegistry registeryFrom(Set<String> scanPackages) {
        return new DefaultInvocableRegistry().register(DefaultInvocableRegistry.perform(scanPackages).stream());
    }

    private static Set<InvocableTypeDefinition> perform(Set<String> scanPackages) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return beanDefinition.getMetadata().isIndependent() || beanDefinition.getMetadata().isInterface();
            }
        };
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ForJmsType.class));
        return StreamOf.nonNull(scanPackages).map(arg_0 -> (scanner).findCandidateComponents(arg_0)).flatMap(Collection::stream).map(bean -> {
            try {
                LOGGER.atTrace().log("Scanning {}", (Object)bean.getBeanClassName());
                return Class.forName(bean.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                LOGGER.atError().log("This should not happen.", (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).map(type -> DefaultInvocableRegistry.newDefinition(type)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static InvocableTypeDefinition newDefinition(Class<?> type) {
        List<Method> invokes;
        ForJmsType annotation = type.getAnnotation(ForJmsType.class);
        if (annotation == null) {
            return null;
        }
        if (Modifier.isAbstract(type.getModifiers()) && annotation.scope().equals((Object)InstanceScope.MESSAGE) || type.isEnum()) {
            throw new IllegalArgumentException("Un-instantiable type " + type.getName());
        }
        Set<String> msgTypes = Arrays.asList(annotation.value()).stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(entry -> {
            if ((Long)entry.getValue() > 1L) {
                throw new IllegalArgumentException("Duplicate type '" + (String)entry.getKey() + "' on " + type.getCanonicalName());
            }
            return (String)entry.getKey();
        }).collect(Collectors.toSet());
        HashMap<String, Method> invokings = new HashMap<String, Method>();
        ReflectingType reflected = new ReflectingType(type);
        for (Method method : reflected.findMethods(Invoking.class)) {
            String invokingName = method.getAnnotation(Invoking.class).value().strip();
            if (invokings.containsKey(invokingName)) {
                throw new IllegalArgumentException("Duplicate invocation methods: " + ((Method)invokings.get(invokingName)).toString() + ", " + method.toString());
            }
            invokings.put(invokingName, method);
        }
        if (invokings.get("") == null && (invokes = reflected.findMethods("invoke")).size() == 1) {
            invokings.put("", invokes.get(0));
        }
        if (invokings.get("") == null) {
            throw new IllegalArgumentException("No invocation method defined by " + type.getName());
        }
        LOGGER.atTrace().log("Registering {} on {}", msgTypes, (Object)type.getCanonicalName());
        return new InvocableTypeDefinition(msgTypes, type, Map.copyOf(invokings), annotation.scope(), annotation.invocation());
    }
}

