/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.dispatch.BodyPublisher;
import me.ehp246.aufjms.api.dispatch.DispatchListener;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.AtQueue;
import me.ehp246.aufjms.api.jms.AufJmsContext;
import me.ehp246.aufjms.api.jms.ConnectionFactoryProvider;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.ToJson;
import me.ehp246.aufjms.core.util.OneUtil;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DefaultDispatchFnProvider
implements JmsDispatchFnProvider,
AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(DefaultDispatchFnProvider.class);
    private final ConnectionFactoryProvider cfProvider;
    private final ToJson toJson;
    private final List<DispatchListener.OnDispatch> onDispatchs = new ArrayList<DispatchListener.OnDispatch>();
    private final List<DispatchListener.PreSend> preSends = new ArrayList<DispatchListener.PreSend>();
    private final List<DispatchListener.PostSend> postSends = new ArrayList<DispatchListener.PostSend>();
    private final List<DispatchListener.OnException> onExs = new ArrayList<DispatchListener.OnException>();
    private final Set<Connection> closeable = ConcurrentHashMap.newKeySet();

    public DefaultDispatchFnProvider(ConnectionFactoryProvider cfProvider, ToJson jsonFn, List<DispatchListener> dispatchListeners) {
        this.cfProvider = Objects.requireNonNull(cfProvider);
        this.toJson = Objects.requireNonNull(jsonFn);
        for (Object listener : dispatchListeners == null ? List.of() : dispatchListeners) {
            if (listener instanceof DispatchListener.OnDispatch) {
                DispatchListener.OnDispatch onDispatch = (DispatchListener.OnDispatch)listener;
                this.onDispatchs.add(onDispatch);
            }
            if (listener instanceof DispatchListener.PreSend) {
                DispatchListener.PreSend preSend = (DispatchListener.PreSend)listener;
                this.preSends.add(preSend);
            }
            if (listener instanceof DispatchListener.PostSend) {
                DispatchListener.PostSend postSend = (DispatchListener.PostSend)listener;
                this.postSends.add(postSend);
            }
            if (!(listener instanceof DispatchListener.OnException)) continue;
            DispatchListener.OnException onEx = (DispatchListener.OnException)listener;
            this.onExs.add(onEx);
        }
    }

    @Override
    public JmsDispatchFn get(final String connectionFactoryName) {
        Connection connection;
        if (connectionFactoryName != null) {
            try {
                connection = this.cfProvider.get(connectionFactoryName).createConnection();
            }
            catch (JMSException e) {
                LOGGER.atError().withThrowable((Throwable)e).log("Failed to create connection on factory '{}': {}", (Object)connectionFactoryName, (Object)e.getMessage());
                throw new JMSRuntimeException(e.getErrorCode(), e.getMessage(), (Throwable)e);
            }
            this.closeable.add(connection);
        } else {
            connection = null;
        }
        return new JmsDispatchFn(){
            private final Logger LOGGER;
            {
                this.LOGGER = LogManager.getLogger((String)(JmsDispatchFn.class.getName() + "@" + connectionFactoryName));
            }

            @Override
            public JmsMsg send(JmsDispatch dispatch) {
                Objects.requireNonNull(dispatch);
                Session session = null;
                MessageProducer producer = null;
                TextMessage message = null;
                JmsMsg msg = null;
                try {
                    for (DispatchListener.OnDispatch onDispatch : DefaultDispatchFnProvider.this.onDispatchs) {
                        onDispatch.onDispatch(dispatch);
                    }
                    if (connection == null && AufJmsContext.getSession() == null) {
                        throw new IllegalStateException("No session available");
                    }
                    session = connection != null ? connection.createSession() : AufJmsContext.getSession();
                    producer = session.createProducer(null);
                    message = session.createTextMessage();
                    msg = TextJmsMsg.from(message);
                    for (Map.Entry entry : Optional.ofNullable(dispatch.properties()).orElseGet(HashMap::new).entrySet()) {
                        message.setObjectProperty(((String)entry.getKey()).toString(), entry.getValue());
                    }
                    message.setJMSReplyTo(DefaultDispatchFnProvider.toJMSDestintation(session, dispatch.replyTo()));
                    message.setJMSType(dispatch.type());
                    message.setJMSCorrelationID(dispatch.correlationId());
                    message.setText(this.toText(dispatch));
                    producer.setDeliveryDelay(Optional.ofNullable(dispatch.delay()).map(Duration::toMillis).orElse(0L).longValue());
                    producer.setTimeToLive(Optional.ofNullable(dispatch.ttl()).map(Duration::toMillis).orElse(0L).longValue());
                    for (DispatchListener.PreSend preSend : DefaultDispatchFnProvider.this.preSends) {
                        preSend.preSend(dispatch, msg);
                    }
                    producer.send(DefaultDispatchFnProvider.toJMSDestintation(session, dispatch.to()), (Message)message);
                    for (DispatchListener.PostSend postSend : DefaultDispatchFnProvider.this.postSends) {
                        postSend.postSend(dispatch, msg);
                    }
                    JmsMsg jmsMsg = msg;
                    return jmsMsg;
                }
                catch (Exception e) {
                    for (DispatchListener.OnException listener : DefaultDispatchFnProvider.this.onExs) {
                        listener.onException(dispatch, msg, e);
                    }
                    if (e instanceof RuntimeException) {
                        RuntimeException runtimeException = (RuntimeException)e;
                        throw runtimeException;
                    }
                    throw OneUtil.ensureRuntime(e);
                }
                finally {
                    if (producer != null) {
                        try {
                            producer.close();
                        }
                        catch (JMSException e) {
                            this.LOGGER.atError().withThrowable((Throwable)e).log("Failed to close producer. Ignored", (Object)e);
                        }
                    }
                    if (connection != null && session != null) {
                        try {
                            session.close();
                        }
                        catch (JMSException e) {
                            this.LOGGER.atError().withThrowable((Throwable)e).log("Failed to close session. Ignored.", (Object)e);
                        }
                    }
                }
            }

            private String toText(JmsDispatch dispatch) {
                Object body = dispatch.body();
                if (body == null) {
                    return null;
                }
                if (body instanceof BodyPublisher) {
                    BodyPublisher publisher = (BodyPublisher)body;
                    return (String)publisher.get();
                }
                return DefaultDispatchFnProvider.this.toJson.apply(List.of(new ToJson.From(body, dispatch.bodyAs().type())));
            }
        };
    }

    private static Destination toJMSDestintation(Session session, At to) throws JMSException {
        if (to == null || !OneUtil.hasValue(to.name())) {
            return null;
        }
        return to instanceof AtQueue ? session.createQueue(to.name()) : session.createTopic(to.name());
    }

    @Override
    public void close() {
        this.closeable.stream().forEach(t -> {
            try {
                t.close();
            }
            catch (JMSException e) {
                LOGGER.atError().withThrowable((Throwable)e).log("Failed to close connection. Ignored", (Object)e);
            }
        });
        this.closeable.clear();
    }
}

