/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import me.ehp246.aufjms.api.annotation.OfCorrelationId;
import me.ehp246.aufjms.api.annotation.OfDelay;
import me.ehp246.aufjms.api.annotation.OfProperty;
import me.ehp246.aufjms.api.annotation.OfTtl;
import me.ehp246.aufjms.api.annotation.OfType;
import me.ehp246.aufjms.api.dispatch.ByJmsProxyConfig;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.reflection.ReflecteProxydMethod;
import me.ehp246.aufjms.core.reflection.ReflectedParameter;
import me.ehp246.aufjms.core.util.OneUtil;

final class MethodParsingDispatchBuilder {
    private static final Set<Class<? extends Annotation>> PARAMETER_ANNOTATIONS = Set.of(OfType.class, OfProperty.class, OfTtl.class, OfDelay.class, OfCorrelationId.class);
    private final ReflecteProxydMethod reflected;
    private final Function<Object[], String> typeFn;
    private final Function<Object[], String> correlIdFn;
    private final Function<Object[], Duration> ttlFn;
    private final Function<Object[], Duration> delayFn;
    private final int[] propertyArgs;
    private final String[] propertyNames;
    private final Class<?>[] propertyTypes;
    private final int bodyIndex;
    private final JmsDispatch.BodyAs bodyAs;

    private MethodParsingDispatchBuilder(Method method, PropertyResolver propertyResolver) {
        this.reflected = new ReflecteProxydMethod(method);
        this.typeFn = this.reflected.allParametersWith(OfType.class).stream().findFirst().map(p -> args -> (String)args[p.index()]).orElseGet(() -> this.reflected.findOnMethodUp(OfType.class).map(an -> args -> an.value()).orElseGet(() -> args -> OneUtil.firstUpper(method.getName())));
        this.correlIdFn = this.reflected.allParametersWith(OfCorrelationId.class).stream().findFirst().map(p -> args -> (String)args[p.index()]).orElse(null);
        this.ttlFn = this.reflected.allParametersWith(OfTtl.class).stream().findFirst().map(p -> args -> (Duration)args[p.index()]).orElseGet(() -> this.reflected.findOnMethodUp(OfTtl.class).map(a -> args -> Duration.parse(propertyResolver.resolve(a.value()))).orElse(null));
        this.delayFn = this.reflected.allParametersWith(OfDelay.class).stream().findFirst().map(p -> args -> (Duration)args[p.index()]).orElseGet(() -> this.reflected.findOnMethodUp(OfDelay.class).map(a -> args -> Duration.parse(propertyResolver.resolve(a.value()))).orElse(null));
        ArrayList propArgs = new ArrayList();
        ArrayList propNames = new ArrayList();
        ArrayList propTypes = new ArrayList();
        this.reflected.allParametersWith(OfProperty.class).stream().forEach(p -> {
            propArgs.add(p.index());
            propNames.add(p.parameter().getAnnotation(OfProperty.class).value());
            propTypes.add(p.parameter().getType());
        });
        this.propertyArgs = new int[propArgs.size()];
        this.propertyNames = new String[propArgs.size()];
        this.propertyTypes = new Class[propArgs.size()];
        for (int i = 0; i < propArgs.size(); ++i) {
            this.propertyArgs[i] = (Integer)propArgs.get(i);
            this.propertyNames[i] = (String)propNames.get(i);
            this.propertyTypes[i] = (Class)propTypes.get(i);
        }
        this.bodyIndex = this.reflected.firstPayloadParameter(PARAMETER_ANNOTATIONS).map(ReflectedParameter::index).orElse(-1);
        this.bodyAs = this.bodyIndex == -1 ? null : this.reflected.getParameter(this.bodyIndex)::getType;
    }

    public static MethodParsingDispatchBuilder parse(Method method) {
        return MethodParsingDispatchBuilder.parse(method, Object::toString);
    }

    public static MethodParsingDispatchBuilder parse(Method method, PropertyResolver propertyResolver) {
        return new MethodParsingDispatchBuilder(method, propertyResolver);
    }

    public JmsDispatch apply(final ByJmsProxyConfig config, Object[] args) {
        final At to = config.to();
        final String type = this.typeFn.apply(args);
        final String correlId = this.correlIdFn == null ? UUID.randomUUID().toString() : this.correlIdFn.apply(args);
        final Duration ttl = this.ttlFn == null ? config.ttl() : this.ttlFn.apply(args);
        final Duration delay = this.delayFn == null ? config.delay() : this.delayFn.apply(args);
        final HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < this.propertyArgs.length; ++i) {
            int argIndex = this.propertyArgs[i];
            String key = this.propertyNames[i];
            Object arg = args[argIndex];
            if (!OneUtil.hasValue(key) && !this.propertyTypes[i].isAssignableFrom(Map.class)) {
                throw new IllegalArgumentException("Un-defined property name on parameter " + this.reflected.getParameter(argIndex));
            }
            if (this.propertyTypes[i].isAssignableFrom(Map.class)) {
                if (arg == null) continue;
                properties.putAll((Map)arg);
                continue;
            }
            properties.put(key, arg);
        }
        final Object body = this.bodyIndex == -1 ? null : args[this.bodyIndex];
        return new JmsDispatch(){

            @Override
            public At to() {
                return to;
            }

            @Override
            public String type() {
                return type;
            }

            @Override
            public String correlationId() {
                return correlId;
            }

            @Override
            public Object body() {
                return body;
            }

            @Override
            public JmsDispatch.BodyAs bodyAs() {
                return MethodParsingDispatchBuilder.this.bodyAs;
            }

            @Override
            public At replyTo() {
                return config.replyTo();
            }

            @Override
            public Duration ttl() {
                return ttl;
            }

            @Override
            public Map<String, Object> properties() {
                return properties;
            }

            @Override
            public Duration delay() {
                return delay;
            }
        };
    }
}

