/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.endpoint.ExecutorProvider;
import me.ehp246.aufjms.api.endpoint.InboundEndpoint;
import me.ehp246.aufjms.api.endpoint.Invocable;
import me.ehp246.aufjms.api.endpoint.InvocableBinder;
import me.ehp246.aufjms.api.endpoint.Invoked;
import me.ehp246.aufjms.api.endpoint.MsgContext;
import me.ehp246.aufjms.api.endpoint.MsgInvocableFactory;
import me.ehp246.aufjms.api.exception.UnknownTypeException;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.AtTopic;
import me.ehp246.aufjms.api.jms.AufJmsContext;
import me.ehp246.aufjms.api.jms.ConnectionFactoryProvider;
import me.ehp246.aufjms.api.jms.JMSSupplier;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.Log4jContext;
import me.ehp246.aufjms.core.endpoint.InvocableDispatcher;
import me.ehp246.aufjms.core.endpoint.ReplyInvoked;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.jms.listener.SessionAwareMessageListener;

public final class InboundEndpointListenerConfigurer
implements JmsListenerConfigurer {
    static final Logger LOGGER = LogManager.getLogger(InboundEndpointListenerConfigurer.class);
    private final Set<InboundEndpoint> endpoints;
    private final ExecutorProvider executorProvider;
    private final InvocableBinder binder;
    private final ConnectionFactoryProvider cfProvider;
    private final JmsDispatchFnProvider dispathFnProvider;

    public InboundEndpointListenerConfigurer(ConnectionFactoryProvider cfProvider, Set<InboundEndpoint> endpoints, ExecutorProvider executorProvider, InvocableBinder binder, JmsDispatchFnProvider dispathFnProvider) {
        this.cfProvider = Objects.requireNonNull(cfProvider);
        this.endpoints = endpoints;
        this.executorProvider = executorProvider;
        this.binder = binder;
        this.dispathFnProvider = dispathFnProvider;
    }

    public void configureJmsListeners(JmsListenerEndpointRegistrar registrar) {
        DefaultJmsListenerContainerFactory listenerContainerFactory = this.jmsListenerContainerFactory(null);
        for (final InboundEndpoint endpoint : this.endpoints) {
            LOGGER.atTrace().log("Registering '{}' endpoint on '{}'", (Object)endpoint.name(), (Object)endpoint.from().on());
            registrar.registerEndpoint(new JmsListenerEndpoint(){

                public void setupListenerContainer(MessageListenerContainer listenerContainer) {
                    AbstractMessageListenerContainer container = (AbstractMessageListenerContainer)listenerContainer;
                    InboundEndpoint.From from = endpoint.from();
                    At on = from.on();
                    container.setBeanName(endpoint.name());
                    container.setAutoStartup(endpoint.autoStartup());
                    container.setMessageSelector(from.selector());
                    container.setDestinationName(on.name());
                    if (on instanceof AtTopic) {
                        InboundEndpoint.From.Sub sub = from.sub();
                        container.setSubscriptionName(sub.name());
                        container.setSubscriptionDurable(sub.durable());
                        container.setSubscriptionShared(sub.shared());
                    }
                    container.setDestinationResolver((session, name, topic) -> JMSSupplier.invoke(() -> on instanceof AtTopic ? session.createTopic(on.name()) : session.createQueue(on.name())));
                    container.setupMessageListener((Object)new SessionAwareMessageListener<Message>(){
                        private static final Logger logger = LogManager.getLogger(InboundEndpoint.class);
                        private final InvocableDispatcher dispatcher;
                        private final MsgInvocableFactory invocableFactory;
                        {
                            this.dispatcher = new InvocableDispatcher(InboundEndpointListenerConfigurer.this.binder, Invoked::invoke, Arrays.asList(new ReplyInvoked(InboundEndpointListenerConfigurer.this.dispathFnProvider.get(endpoint.connectionFactory())), endpoint.invocationListener()), InboundEndpointListenerConfigurer.this.executorProvider.get(endpoint.concurrency()));
                            this.invocableFactory = endpoint.invocableFactory();
                        }

                        public void onMessage(Message message, final Session session) throws JMSException {
                            if (!(message instanceof TextMessage)) {
                                throw new IllegalArgumentException("Un-supported message type of " + message.getJMSCorrelationID());
                            }
                            TextMessage textMessage = (TextMessage)message;
                            final JmsMsg msg = TextJmsMsg.from(textMessage);
                            try {
                                AufJmsContext.set(session);
                                Log4jContext.set(msg);
                                Supplier[] supplierArray = new Supplier[1];
                                supplierArray[0] = msg::correlationId;
                                logger.atTrace().log("Consuming {}", supplierArray);
                                Invocable invocable = this.invocableFactory.get(msg);
                                if (invocable == null) {
                                    throw new UnknownTypeException(msg);
                                }
                                MsgContext msgCtx = new MsgContext(){

                                    @Override
                                    public JmsMsg msg() {
                                        return msg;
                                    }

                                    @Override
                                    public Session session() {
                                        return session;
                                    }
                                };
                                logger.atTrace().log("Dispatching {}", new Supplier[]{() -> invocable.method().toString()});
                                this.dispatcher.dispatch(invocable, msgCtx);
                                Supplier[] supplierArray2 = new Supplier[1];
                                supplierArray2[0] = msg::correlationId;
                                logger.atTrace().log("Consumed {}", supplierArray2);
                            }
                            catch (Exception e) {
                                logger.atError().withThrowable((Throwable)e).log("Message failed: {}", (Object)e.getMessage());
                                throw e;
                            }
                            finally {
                                AufJmsContext.clearSession();
                                Log4jContext.clear();
                            }
                        }
                    });
                }

                public String getId() {
                    return endpoint.name();
                }
            }, (JmsListenerContainerFactory)listenerContainerFactory);
        }
    }

    private DefaultJmsListenerContainerFactory jmsListenerContainerFactory(String cfName) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(this.cfProvider.get(cfName));
        factory.setSessionTransacted(Boolean.valueOf(true));
        factory.setSessionAcknowledgeMode(Integer.valueOf(2));
        return factory;
    }
}

