/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import me.ehp246.aufjms.api.dispatch.ByJmsProxyConfig;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.core.reflection.ReflectedProxyMethod;
import me.ehp246.aufjms.core.util.OneUtil;

final class ParsedMethodDispatchBuilder {
    private final ReflectedProxyMethod reflected;
    private final ByJmsProxyConfig config;
    private final Function<Object[], String> typeFn;
    private final Function<Object[], String> correlIdFn;
    private final Function<Object[], String> groupIdFn;
    private final Function<Object[], Integer> groupSeqFn;
    private final Function<Object[], Duration> ttlFn;
    private final Function<Object[], Duration> delayFn;
    private final int[] propertyArgs;
    private final String[] propertyNames;
    private final Class<?>[] propertyTypes;
    private final int bodyIndex;
    private final JmsDispatch.BodyAs bodyAs;

    ParsedMethodDispatchBuilder(ReflectedProxyMethod reflected, ByJmsProxyConfig config, Function<Object[], String> typeFn, Function<Object[], String> correlIdFn, int bodyIndex, JmsDispatch.BodyAs bodyAs, int[] propertyArgs, Class<?>[] propertyTypes, String[] propertyNames, Function<Object[], Duration> ttlFn, Function<Object[], Duration> delayFn, Function<Object[], String> groupIdFn, Function<Object[], Integer> groupSeqFn) {
        this.reflected = reflected;
        this.config = config;
        this.typeFn = typeFn;
        this.correlIdFn = correlIdFn;
        this.ttlFn = ttlFn;
        this.delayFn = delayFn;
        this.groupIdFn = groupIdFn;
        this.groupSeqFn = groupSeqFn;
        this.propertyArgs = propertyArgs;
        this.propertyNames = propertyNames;
        this.propertyTypes = propertyTypes;
        this.bodyIndex = bodyIndex;
        this.bodyAs = bodyAs;
    }

    public JmsDispatch apply(Object target, Object[] args) {
        final At to = this.config.to();
        final String type = this.typeFn.apply(args);
        final String correlId = this.correlIdFn == null ? UUID.randomUUID().toString() : this.correlIdFn.apply(args);
        final Duration ttl = this.ttlFn == null ? this.config.ttl() : this.ttlFn.apply(args);
        final Duration delay = this.delayFn == null ? this.config.delay() : this.delayFn.apply(args);
        final String groupId = this.groupIdFn == null ? null : this.groupIdFn.apply(args);
        final int groupSeq = groupId == null || this.groupSeqFn == null ? 0 : this.groupSeqFn.apply(args);
        final HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < this.propertyArgs.length; ++i) {
            int argIndex = this.propertyArgs[i];
            String key = this.propertyNames[i];
            Object arg = args[argIndex];
            if (!OneUtil.hasValue(key) && !this.propertyTypes[i].isAssignableFrom(Map.class)) {
                throw new IllegalArgumentException("Un-defined property name on parameter " + this.reflected.getParameter(argIndex));
            }
            if (this.propertyTypes[i].isAssignableFrom(Map.class)) {
                if (arg == null) continue;
                properties.putAll((Map)arg);
                continue;
            }
            properties.put(key, arg);
        }
        final Object body = this.bodyIndex == -1 ? null : args[this.bodyIndex];
        return new JmsDispatch(){

            @Override
            public At to() {
                return to;
            }

            @Override
            public String type() {
                return type;
            }

            @Override
            public String correlationId() {
                return correlId;
            }

            @Override
            public Object body() {
                return body;
            }

            @Override
            public JmsDispatch.BodyAs bodyAs() {
                return ParsedMethodDispatchBuilder.this.bodyAs;
            }

            @Override
            public At replyTo() {
                return ParsedMethodDispatchBuilder.this.config.replyTo();
            }

            @Override
            public Duration ttl() {
                return ttl;
            }

            @Override
            public String groupId() {
                return groupId;
            }

            @Override
            public int groupSeq() {
                return groupSeq;
            }

            @Override
            public Map<String, Object> properties() {
                return properties;
            }

            @Override
            public Duration delay() {
                return delay;
            }
        };
    }
}

