/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jms.Session;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.annotation.OfCorrelationId;
import me.ehp246.aufjms.api.annotation.OfDeliveryCount;
import me.ehp246.aufjms.api.annotation.OfGroupId;
import me.ehp246.aufjms.api.annotation.OfGroupSeq;
import me.ehp246.aufjms.api.annotation.OfProperty;
import me.ehp246.aufjms.api.annotation.OfRedelivered;
import me.ehp246.aufjms.api.annotation.OfType;
import me.ehp246.aufjms.api.endpoint.BoundInvocable;
import me.ehp246.aufjms.api.endpoint.Invocable;
import me.ehp246.aufjms.api.endpoint.InvocableBinder;
import me.ehp246.aufjms.api.endpoint.MsgContext;
import me.ehp246.aufjms.api.jms.JMSSupplier;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.FromJson;
import me.ehp246.aufjms.core.endpoint.BoundInvocableRecord;

public final class DefaultInvocableBinder
implements InvocableBinder {
    private static final Map<Class<? extends Annotation>, Function<JmsMsg, Object>> HEADER_VALUE_SUPPLIERS = Map.of(OfType.class, JmsMsg::type, OfCorrelationId.class, JmsMsg::correlationId, OfDeliveryCount.class, msg -> msg.property("JMSXDeliveryCount", Integer.class), OfGroupId.class, JmsMsg::groupId, OfGroupSeq.class, JmsMsg::groupSeq, OfRedelivered.class, JmsMsg::redelivered);
    private static final Set<Class<? extends Annotation>> HEADER_ANNOTATIONS = Set.copyOf(HEADER_VALUE_SUPPLIERS.keySet());
    private final FromJson fromJson;

    public DefaultInvocableBinder(FromJson fromJson) {
        this.fromJson = fromJson;
    }

    @Override
    public BoundInvocable bind(Invocable target, MsgContext ctx) {
        Method method = target.method();
        method.setAccessible(true);
        if (method.getParameterCount() == 0) {
            return new BoundInvocableRecord(target, ctx.msg());
        }
        final Parameter[] parameters = method.getParameters();
        final Object[] arguments = new Object[parameters.length];
        boolean[] boundMarkers = this.bindContextArgs(parameters, ctx, arguments);
        ArrayList<FromJson.To> receivers = new ArrayList<FromJson.To>();
        for (int i = 0; i < boundMarkers.length; ++i) {
            if (boundMarkers[i]) continue;
            final Integer ref = i;
            receivers.add(new FromJson.To(){

                public void receive(Object value) {
                    arguments[ref.intValue()] = value;
                }

                @Override
                public Class<?> type() {
                    return parameters[ref].getType();
                }

                @Override
                public List<? extends Annotation> annotations() {
                    return List.of(parameters[ref].getAnnotations());
                }
            });
        }
        if (receivers.size() > 0) {
            this.fromJson.apply(ctx.msg().text(), receivers);
        }
        return new BoundInvocableRecord(target, Arrays.asList(arguments), ctx.msg());
    }

    private boolean[] bindContextArgs(Parameter[] parameters, MsgContext ctx, Object[] arguments) {
        boolean[] markers = new boolean[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            JmsMsg msg = ctx.msg();
            Class<Object> type = parameter.getType();
            if (type.isAssignableFrom(JmsMsg.class)) {
                arguments[i] = msg;
                markers[i] = true;
            } else if (type.isAssignableFrom(TextMessage.class)) {
                arguments[i] = msg.message();
                markers[i] = true;
            } else if (type.isAssignableFrom(MsgContext.class)) {
                arguments[i] = ctx;
                markers[i] = true;
            } else if (type.isAssignableFrom(FromJson.class)) {
                arguments[i] = this.fromJson;
                markers[i] = true;
            } else if (type.isAssignableFrom(Session.class)) {
                arguments[i] = ctx.session();
                markers[i] = true;
            }
            Annotation[] annotations = parameter.getAnnotations();
            Optional<Annotation> found = Stream.of(annotations).filter(annotation -> HEADER_ANNOTATIONS.contains(annotation.annotationType())).findAny();
            if (found.isPresent()) {
                arguments[i] = HEADER_VALUE_SUPPLIERS.get(found.get().annotationType()).apply(msg);
                markers[i] = true;
            }
            if (!(found = Stream.of(annotations).filter(annotation -> annotation.annotationType() == OfProperty.class).findAny()).isPresent()) continue;
            arguments[i] = Map.class.isAssignableFrom(type) ? DefaultInvocableBinder.propertyMap(msg) : msg.property(((OfProperty)found.get()).value(), type);
            markers[i] = true;
        }
        return markers;
    }

    private static Map<String, Object> propertyMap(JmsMsg msg) {
        TextMessage message = msg.message();
        return msg.propertyNames().stream().collect(Collectors.toMap(Function.identity(), name -> JMSSupplier.invoke(() -> message.getObjectProperty(name))));
    }
}

