/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.endpoint.ExecutorProvider;
import me.ehp246.aufjms.api.endpoint.InboundEndpoint;
import me.ehp246.aufjms.api.endpoint.InvocableBinder;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.AtTopic;
import me.ehp246.aufjms.api.jms.ConnectionFactoryProvider;
import me.ehp246.aufjms.core.endpoint.DefaultInboundMessageListener;
import me.ehp246.aufjms.core.endpoint.DefaultInvocableDispatcher;
import me.ehp246.aufjms.core.endpoint.ReplyInvoked;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.MessageListenerContainer;

public final class InboundEndpointListenerConfigurer
implements JmsListenerConfigurer {
    static final Logger LOGGER = LogManager.getLogger(InboundEndpointListenerConfigurer.class);
    private final Set<InboundEndpoint> endpoints;
    private final ExecutorProvider executorProvider;
    private final InvocableBinder binder;
    private final ConnectionFactoryProvider cfProvider;
    private final JmsDispatchFnProvider dispathFnProvider;

    public InboundEndpointListenerConfigurer(ConnectionFactoryProvider cfProvider, Set<InboundEndpoint> endpoints, ExecutorProvider executorProvider, InvocableBinder binder, JmsDispatchFnProvider dispathFnProvider) {
        this.cfProvider = Objects.requireNonNull(cfProvider);
        this.endpoints = endpoints;
        this.executorProvider = executorProvider;
        this.binder = binder;
        this.dispathFnProvider = dispathFnProvider;
    }

    public void configureJmsListeners(JmsListenerEndpointRegistrar registrar) {
        DefaultJmsListenerContainerFactory listenerContainerFactory = this.jmsListenerContainerFactory(null);
        for (final InboundEndpoint endpoint : this.endpoints) {
            LOGGER.atTrace().log("Registering '{}' endpoint on '{}'", (Object)endpoint.name(), (Object)endpoint.from().on());
            registrar.registerEndpoint(new JmsListenerEndpoint(){

                public void setupListenerContainer(MessageListenerContainer listenerContainer) {
                    AbstractMessageListenerContainer container = (AbstractMessageListenerContainer)listenerContainer;
                    InboundEndpoint.From from = endpoint.from();
                    At on = from.on();
                    container.setBeanName(endpoint.name());
                    container.setAutoStartup(endpoint.autoStartup());
                    container.setMessageSelector(from.selector());
                    container.setDestinationName(on.name());
                    if (on instanceof AtTopic) {
                        InboundEndpoint.From.Sub sub = from.sub();
                        container.setSubscriptionName(sub.name());
                        container.setSubscriptionDurable(sub.durable());
                        container.setSubscriptionShared(sub.shared());
                    }
                    container.setupMessageListener((Object)new DefaultInboundMessageListener(new DefaultInvocableDispatcher(InboundEndpointListenerConfigurer.this.binder, Arrays.asList(new ReplyInvoked(InboundEndpointListenerConfigurer.this.dispathFnProvider.get(endpoint.connectionFactory())), endpoint.invocationListener()), InboundEndpointListenerConfigurer.this.executorProvider.get(endpoint.concurrency())), endpoint.invocableFactory(), endpoint.defaultConsumer()));
                }

                public String getId() {
                    return endpoint.name();
                }
            }, (JmsListenerContainerFactory)listenerContainerFactory);
        }
    }

    private DefaultJmsListenerContainerFactory jmsListenerContainerFactory(String cfName) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(this.cfProvider.get(cfName));
        factory.setSessionTransacted(Boolean.valueOf(true));
        factory.setSessionAcknowledgeMode(Integer.valueOf(2));
        return factory;
    }
}

