/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.provider.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.ehp246.aufjms.api.annotation.CollectionOf;
import me.ehp246.aufjms.api.spi.FromJson;
import me.ehp246.aufjms.api.spi.ToJson;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JsonByJackson
implements FromJson,
ToJson {
    private static final Logger LOGGER = LogManager.getLogger(JsonByJackson.class);
    private final ObjectMapper objectMapper;

    public JsonByJackson(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String apply(List<ToJson.From> values) {
        try {
            String json = null;
            if (values == null) {
                json = null;
            } else if (values.size() == 1) {
                ToJson.From target = values.get(0);
                json = this.objectMapper.writerFor(target.type()).writeValueAsString(target.value());
            } else if (values.size() > 1) {
                ArrayList<String> list = new ArrayList<String>(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    ToJson.From target = values.get(i);
                    list.add(this.objectMapper.writerFor(target.type()).writeValueAsString(target.value()));
                }
                json = this.objectMapper.writeValueAsString(list);
            }
            return json;
        }
        catch (Exception e) {
            LOGGER.atError().log("Failed to serialize: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<?> apply(String body, List<FromJson.To> receivers) {
        if (receivers == null || receivers.size() == 0) {
            return List.of();
        }
        try {
            if (receivers.size() == 1) {
                return Arrays.asList(this.receiveOne(body, receivers.get(0)));
            }
            String[] jsons = (String[])this.objectMapper.readValue(body, String[].class);
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < receivers.size(); ++i) {
                values.add(this.receiveOne(jsons[i], receivers.get(i)));
            }
            return values;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to read from {}", (Object)body, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private Object receiveOne(String json, FromJson.To receiver) throws JsonMappingException, JsonProcessingException {
        return json != null && !json.isBlank() ? this.readOne(json, receiver) : null;
    }

    private Object readOne(String json, FromJson.To receiver) throws JsonMappingException, JsonProcessingException {
        Class[] collectionOf;
        Class[] classArray = collectionOf = receiver.annotations() == null ? null : (Class[])receiver.annotations().stream().filter(ann -> ann instanceof CollectionOf).findAny().map(ann -> ((CollectionOf)ann).value()).orElse(null);
        if (collectionOf == null) {
            return this.objectMapper.readValue(json, receiver.type());
        }
        if (collectionOf.length == 1) {
            return this.objectMapper.readValue(json, this.objectMapper.getTypeFactory().constructParametricType(receiver.type(), collectionOf));
        }
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(receiver.type());
        types.addAll(List.of(collectionOf));
        int size = types.size();
        JavaType type = typeFactory.constructParametricType((Class)types.get(size - 2), new Class[]{(Class)types.get(size - 1)});
        for (int i = size - 3; i >= 0; --i) {
            type = typeFactory.constructParametricType((Class)types.get(i), new JavaType[]{type});
        }
        return this.objectMapper.readValue(json, type);
    }
}

