/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import me.ehp246.aufjms.api.annotation.OfCorrelationId;
import me.ehp246.aufjms.api.annotation.OfDelay;
import me.ehp246.aufjms.api.annotation.OfGroupId;
import me.ehp246.aufjms.api.annotation.OfGroupSeq;
import me.ehp246.aufjms.api.annotation.OfProperty;
import me.ehp246.aufjms.api.annotation.OfTtl;
import me.ehp246.aufjms.api.annotation.OfType;
import me.ehp246.aufjms.api.dispatch.ByJmsProxyConfig;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.dispatch.ParsedMethodDispatchBuilder;
import me.ehp246.aufjms.core.reflection.ReflectedParameter;
import me.ehp246.aufjms.core.reflection.ReflectedProxyMethod;
import me.ehp246.aufjms.core.util.OneUtil;

final class ProxyMethodParser {
    private static final Set<Class<? extends Annotation>> PARAMETER_ANNOTATIONS = Set.of(OfType.class, OfProperty.class, OfTtl.class, OfDelay.class, OfCorrelationId.class);
    private final PropertyResolver propertyResolver;

    ProxyMethodParser(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    ParsedMethodDispatchBuilder parse(Method method, ByJmsProxyConfig config) {
        ReflectedProxyMethod reflected = new ReflectedProxyMethod(method);
        Function typeFn = reflected.allParametersWith(OfType.class).stream().findFirst().map(p -> args -> (String)args[p.index()]).orElseGet(() -> reflected.findOnMethodUp(OfType.class).map(an -> args -> an.value()).orElseGet(() -> args -> OneUtil.firstUpper(method.getName())));
        Function correlIdFn = reflected.allParametersWith(OfCorrelationId.class).stream().findFirst().map(p -> args -> (String)args[p.index()]).orElse(null);
        Function ttlFn = reflected.allParametersWith(OfTtl.class).stream().findFirst().map(p -> args -> (Duration)args[p.index()]).orElseGet(() -> reflected.findOnMethodUp(OfTtl.class).map(a -> args -> Duration.parse(this.propertyResolver.resolve(a.value()))).orElse(null));
        Function delayFn = reflected.allParametersWith(OfDelay.class).stream().findFirst().map(p -> {
            Class<Object> type = p.parameter().getType();
            if (type.isAssignableFrom(String.class)) {
                return args -> {
                    Object delayArg = args[p.index()];
                    if (delayArg == null) {
                        return null;
                    }
                    return Duration.parse((String)delayArg);
                };
            }
            if (type.isAssignableFrom(Duration.class)) {
                return args -> (Duration)args[p.index()];
            }
            throw new IllegalArgumentException("Un-supported Delay type '" + type.getName() + "' on '" + reflected.method().toString() + "'");
        }).orElseGet(() -> reflected.findOnMethodUp(OfDelay.class).map(a -> {
            Duration parsed = Duration.parse(this.propertyResolver.resolve(a.value()));
            return args -> parsed;
        }).orElse(null));
        Function groupIdFn = reflected.allParametersWith(OfGroupId.class).stream().findFirst().map(p -> {
            Class<String> type = p.parameter().getType();
            if (type.isAssignableFrom(String.class)) {
                return args -> (String)args[p.index()];
            }
            throw new IllegalArgumentException("Un-supported GroupId type '" + type.getName() + "' on '" + reflected.method().toString() + "'");
        }).orElseGet(() -> reflected.findOnMethodUp(OfGroupId.class).map(a -> {
            String parsed = this.propertyResolver.resolve(a.value());
            return args -> parsed;
        }).orElse(null));
        Function groupSeqFn = reflected.allParametersWith(OfGroupSeq.class).stream().findFirst().map(p -> {
            Class<Integer> type = p.parameter().getType();
            if (type == Integer.TYPE || type.isAssignableFrom(Integer.class)) {
                return args -> (Integer)args[p.index()];
            }
            throw new IllegalArgumentException("Un-supported GroupSeq type '" + type.getName() + "' on '" + reflected.method().toString() + "'");
        }).orElse(null);
        ArrayList propArgs = new ArrayList();
        ArrayList propNames = new ArrayList();
        ArrayList propTypes = new ArrayList();
        reflected.allParametersWith(OfProperty.class).stream().forEach(p -> {
            propArgs.add(p.index());
            Parameter parameter = p.parameter();
            propNames.add(OneUtil.getIfBlank(parameter.getAnnotation(OfProperty.class).value(), () -> OneUtil.firstUpper(parameter.getName())));
            propTypes.add(parameter.getType());
        });
        int[] propertyArgs = new int[propArgs.size()];
        String[] propertyNames = new String[propArgs.size()];
        Class[] propertyTypes = new Class[propArgs.size()];
        for (int i = 0; i < propArgs.size(); ++i) {
            propertyArgs[i] = (Integer)propArgs.get(i);
            propertyNames[i] = (String)propNames.get(i);
            propertyTypes[i] = (Class)propTypes.get(i);
        }
        Integer bodyIndex = reflected.firstPayloadParameter(PARAMETER_ANNOTATIONS).map(ReflectedParameter::index).orElse(-1);
        JmsDispatch.BodyAs bodyAs = bodyIndex == -1 ? null : reflected.getParameter(bodyIndex)::getType;
        return new ParsedMethodDispatchBuilder(reflected, config, typeFn, correlIdFn, bodyIndex, bodyAs, propertyArgs, propertyTypes, propertyNames, ttlFn, delayFn, groupIdFn, groupSeqFn);
    }
}

