/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.annotation.OfCorrelationId;
import me.ehp246.aufjms.api.annotation.OfDeliveryCount;
import me.ehp246.aufjms.api.annotation.OfGroupId;
import me.ehp246.aufjms.api.annotation.OfGroupSeq;
import me.ehp246.aufjms.api.annotation.OfProperty;
import me.ehp246.aufjms.api.annotation.OfRedelivered;
import me.ehp246.aufjms.api.annotation.OfType;
import me.ehp246.aufjms.api.endpoint.BoundInvocable;
import me.ehp246.aufjms.api.endpoint.Invocable;
import me.ehp246.aufjms.api.endpoint.InvocableBinder;
import me.ehp246.aufjms.api.jms.JMSSupplier;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.FromJson;
import me.ehp246.aufjms.core.endpoint.BoundInvocableRecord;
import me.ehp246.aufjms.core.util.OneUtil;

public final class DefaultInvocableBinder
implements InvocableBinder {
    private static final Map<Class<? extends Annotation>, Function<JmsMsg, Object>> HEADER_VALUE_SUPPLIERS = Map.of(OfType.class, JmsMsg::type, OfCorrelationId.class, JmsMsg::correlationId, OfDeliveryCount.class, msg -> msg.property("JMSXDeliveryCount", Integer.class), OfGroupId.class, JmsMsg::groupId, OfGroupSeq.class, JmsMsg::groupSeq, OfRedelivered.class, JmsMsg::redelivered);
    private static final Set<Class<? extends Annotation>> HEADER_ANNOTATIONS = Set.copyOf(HEADER_VALUE_SUPPLIERS.keySet());
    private final Map<Method, Parsed> parsed = new ConcurrentHashMap<Method, Parsed>();
    private final FromJson fromJson;

    public DefaultInvocableBinder(FromJson fromJson) {
        this.fromJson = fromJson;
    }

    @Override
    public BoundInvocable bind(Invocable target, JmsMsg msg) {
        Method method = target.method();
        Parsed parsed = this.parsed.computeIfAbsent(method, this::parse);
        Iterator<?> payloadArgs = this.fromJson.apply(msg.text(), parsed.getPayloadReceivers()).iterator();
        int parameterCount = method.getParameterCount();
        Object[] arguments = new Object[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            Function<JmsMsg, Object> ctxArgFn = parsed.getCtxReceiver(i);
            arguments[i] = ctxArgFn != null ? ctxArgFn.apply(msg) : payloadArgs.next();
        }
        return new BoundInvocableRecord(target, arguments, msg);
    }

    private Parsed parse(Method method) {
        method.setAccessible(true);
        Parameter[] parameters = method.getParameters();
        Parsed parsed = new Parsed();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Class<Object> type = parameter.getType();
            if (type.isAssignableFrom(JmsMsg.class)) {
                parsed.addCtxParameter(msg -> msg);
                continue;
            }
            if (type.isAssignableFrom(TextMessage.class)) {
                parsed.addCtxParameter(msg -> msg.message());
                continue;
            }
            if (type.isAssignableFrom(FromJson.class)) {
                parsed.addCtxParameter(msg -> this.fromJson);
                continue;
            }
            Annotation[] annotations = parameter.getAnnotations();
            Optional<Annotation> header = Stream.of(annotations).filter(annotation -> HEADER_ANNOTATIONS.contains(annotation.annotationType())).findAny();
            if (header.isPresent()) {
                Function<JmsMsg, Object> fn = HEADER_VALUE_SUPPLIERS.get(header.get().annotationType());
                parsed.addCtxParameter(msg -> fn.apply((JmsMsg)msg));
                continue;
            }
            Optional<OfProperty> prop = Stream.of(annotations).filter(ann -> ann.annotationType() == OfProperty.class).findAny().map(ann -> (OfProperty)ann);
            if (prop.isPresent()) {
                if (Map.class.isAssignableFrom(type)) {
                    parsed.addCtxParameter(msg -> msg.propertyNames().stream().collect(Collectors.toMap(Function.identity(), name -> JMSSupplier.invoke(() -> msg.message().getObjectProperty(name)))));
                    continue;
                }
                String name = OneUtil.getIfBlank(prop.get().value(), () -> OneUtil.firstUpper(parameter.getName()));
                parsed.addCtxParameter(msg -> msg.property(name, type));
                continue;
            }
            parsed.addPayloadParameter(new FromJson.To(parameter.getType(), List.of(parameter.getAnnotations())));
        }
        return parsed;
    }

    static class Parsed {
        private final List<FromJson.To> payloadReceivers = new ArrayList<FromJson.To>();
        private final List<Function<JmsMsg, Object>> ctxReceivers = new ArrayList<Function<JmsMsg, Object>>();

        Parsed() {
        }

        void addPayloadParameter(FromJson.To to) {
            this.payloadReceivers.add(to);
            this.ctxReceivers.add(null);
        }

        void addCtxParameter(Function<JmsMsg, Object> fn) {
            this.ctxReceivers.add(fn);
        }

        List<FromJson.To> getPayloadReceivers() {
            return this.payloadReceivers;
        }

        Function<JmsMsg, Object> getCtxReceiver(int i) {
            return this.ctxReceivers.get(i);
        }
    }
}

