/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.ehp246.aufjms.api.annotation.ForJmsType;
import me.ehp246.aufjms.api.annotation.Invoking;
import me.ehp246.aufjms.api.endpoint.InstanceScope;
import me.ehp246.aufjms.api.endpoint.InvocableTypeDefinition;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.endpoint.DefaultInvocableRegistry;
import me.ehp246.aufjms.core.reflection.ReflectedType;
import me.ehp246.aufjms.core.util.StreamOf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

final class DefaultInvocableScanner {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PropertyResolver propertyResolver;

    public DefaultInvocableScanner(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public DefaultInvocableRegistry registeryFrom(Set<String> scanPackages) {
        return new DefaultInvocableRegistry().register(this.perform(scanPackages).stream());
    }

    private Set<InvocableTypeDefinition> perform(Set<String> scanPackages) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return beanDefinition.getMetadata().isIndependent() || beanDefinition.getMetadata().isInterface();
            }
        };
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ForJmsType.class));
        return StreamOf.nonNull(scanPackages).map(arg_0 -> (scanner).findCandidateComponents(arg_0)).flatMap(Collection::stream).map(bean -> {
            try {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((BeanDefinition)bean).getBeanClassName();
                LOGGER.atTrace().log("Scanning {}", supplierArray);
                return Class.forName(bean.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                LOGGER.atError().log("This should not happen.", (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).map(this::newDefinition).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private InvocableTypeDefinition newDefinition(Class<?> type) {
        List<Method> invokes;
        String[] stringArray;
        ForJmsType annotation = type.getAnnotation(ForJmsType.class);
        if (annotation == null) {
            return null;
        }
        if (Modifier.isAbstract(type.getModifiers()) && annotation.scope().equals((Object)InstanceScope.MESSAGE) || type.isEnum()) {
            throw new IllegalArgumentException("Un-instantiable type " + type.getName());
        }
        if (annotation.value().length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = type.getSimpleName();
        } else {
            stringArray = annotation.value();
        }
        Set<String> msgTypes = Arrays.asList(stringArray).stream().map(this.propertyResolver::resolve).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(entry -> {
            if ((Long)entry.getValue() > 1L) {
                throw new IllegalArgumentException("Duplicate type '" + (String)entry.getKey() + "' on " + type.getCanonicalName());
            }
            return (String)entry.getKey();
        }).collect(Collectors.toSet());
        HashMap<String, Method> invokings = new HashMap<String, Method>();
        ReflectedType reflected = new ReflectedType(type);
        for (Method method : reflected.findMethods(Invoking.class)) {
            String invokingName = method.getAnnotation(Invoking.class).value().strip();
            if (invokings.containsKey(invokingName)) {
                throw new IllegalArgumentException("Duplicate invocation methods: " + ((Method)invokings.get(invokingName)).toString() + ", " + method.toString());
            }
            invokings.put(invokingName, method);
        }
        if (invokings.get("") == null && (invokes = reflected.findMethods("invoke")).size() == 1) {
            invokings.put("", invokes.get(0));
        }
        if (invokings.get("") == null) {
            throw new IllegalArgumentException("No invocation method defined by " + type.getName());
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = msgTypes::toString;
        supplierArray[1] = type::getCanonicalName;
        LOGGER.atTrace().log("Registering {} on {}", supplierArray);
        return new InvocableTypeDefinition(msgTypes, type, Map.copyOf(invokings), annotation.scope(), annotation.invocation());
    }
}

