/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.api.jms;

import jakarta.jms.Session;
import java.util.Objects;

public final class AufJmsContext {
    private static final AufJmsContext CONTEXT = new AufJmsContext();
    private final ThreadLocal<Session> threadLocalSession = ThreadLocal.withInitial(() -> null);

    private AufJmsContext() {
    }

    public static void set(Session session) {
        Objects.requireNonNull(session);
        if (AufJmsContext.CONTEXT.threadLocalSession.get() != null) {
            throw new IllegalArgumentException("Context session present");
        }
        AufJmsContext.CONTEXT.threadLocalSession.set(session);
    }

    public static Session getSession() {
        return AufJmsContext.CONTEXT.threadLocalSession.get();
    }

    public static Session clearSession() {
        Session session = AufJmsContext.CONTEXT.threadLocalSession.get();
        AufJmsContext.CONTEXT.threadLocalSession.remove();
        return session;
    }
}

