/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.ehp246.aufjms.api.annotation.ByJms;
import me.ehp246.aufjms.api.dispatch.ByJmsProxyConfig;
import me.ehp246.aufjms.api.dispatch.EnableByJmsConfig;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.AtQueue;
import me.ehp246.aufjms.api.jms.DestinationType;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.dispatch.DefaultProxyMethodParser;
import me.ehp246.aufjms.core.dispatch.ProxyInvocationBinder;
import me.ehp246.aufjms.core.util.OneUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public final class ByJmsProxyFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Method, ProxyInvocationBinder> cache = new ConcurrentHashMap<Method, ProxyInvocationBinder>();
    private final JmsDispatchFnProvider dispatchFnProvider;
    private final PropertyResolver propertyResolver;
    private final EnableByJmsConfig enableByJmsConfig;
    private final DefaultProxyMethodParser methodParser;

    public ByJmsProxyFactory(EnableByJmsConfig enableByJmsConfig, JmsDispatchFnProvider dispatchFnProvider, PropertyResolver propertyResolver) {
        this.enableByJmsConfig = enableByJmsConfig;
        this.dispatchFnProvider = dispatchFnProvider;
        this.propertyResolver = propertyResolver;
        this.methodParser = new DefaultProxyMethodParser(propertyResolver);
    }

    public <T> T newByJmsProxy(final Class<T> proxyInterface) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = proxyInterface::getCanonicalName;
        LOGGER.atDebug().log("Instantiating {}", supplierArray);
        final ByJms byJms = proxyInterface.getAnnotation(ByJms.class);
        String toName = this.propertyResolver.resolve(byJms.value().value());
        if (!OneUtil.hasValue(toName)) {
            throw new IllegalArgumentException("Un-supported To: '" + toName + "'");
        }
        final At destination = byJms.value().type() == DestinationType.QUEUE ? At.toQueue(toName) : At.toTopic(toName);
        String replyToName = this.propertyResolver.resolve(byJms.replyTo().value());
        final AtQueue replyTo = OneUtil.hasValue(replyToName) ? (byJms.replyTo().type() == DestinationType.QUEUE ? At.toQueue(replyToName) : At.toTopic(replyToName)) : null;
        final Duration ttl = Optional.of(this.propertyResolver.resolve(byJms.ttl())).filter(OneUtil::hasValue).map(Duration::parse).orElseGet(this.enableByJmsConfig::ttl);
        final Duration delay = Optional.of(this.propertyResolver.resolve(byJms.delay())).filter(OneUtil::hasValue).map(Duration::parse).orElseGet(this.enableByJmsConfig::delay);
        return (T)Proxy.newProxyInstance(proxyInterface.getClassLoader(), new Class[]{proxyInterface}, new InvocationHandler(){
            private final ByJmsProxyConfig proxyConfig;
            private final JmsDispatchFn dispatchFn;
            private final int hashCode;
            {
                this.proxyConfig = new ByJmsProxyConfig(destination, replyTo, ttl, delay, byJms.connectionFactory(), List.of(byJms.properties()));
                this.dispatchFn = ByJmsProxyFactory.this.dispatchFnProvider.get(byJms.connectionFactory());
                this.hashCode = new Object().hashCode();
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("toString")) {
                    return ByJmsProxyFactory.this.toString();
                }
                if (method.getName().equals("hashCode")) {
                    return this.hashCode;
                }
                if (method.getName().equals("equals")) {
                    return proxy == args[0];
                }
                if (method.isDefault()) {
                    return MethodHandles.privateLookupIn(proxyInterface, MethodHandles.lookup()).findSpecial(proxyInterface, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), proxyInterface).bindTo(proxy).invokeWithArguments(args);
                }
                JmsDispatch jmsDispatch = ByJmsProxyFactory.this.cache.computeIfAbsent(method, m -> ByJmsProxyFactory.this.methodParser.parse((Method)m, this.proxyConfig)).apply(proxy, args);
                this.dispatchFn.send(jmsDispatch);
                return null;
            }
        });
    }
}

