/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import me.ehp246.aufjms.api.dispatch.DispatchListener;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.api.jms.JmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public final class DispatchLogger
implements DispatchListener.OnDispatch,
DispatchListener.PreSend,
DispatchListener.PostSend,
DispatchListener.OnException {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void onDispatch(JmsDispatch dispatch) {
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = dispatch::to;
        supplierArray[1] = dispatch::type;
        supplierArray[2] = dispatch::correlationId;
        LOGGER.atInfo().log("'{}', '{}', '{}'", supplierArray);
        Supplier[] supplierArray2 = new Supplier[3];
        supplierArray2[0] = dispatch::replyTo;
        supplierArray2[1] = dispatch::ttl;
        supplierArray2[2] = dispatch::delay;
        LOGGER.atDebug().log("'{}', '{}', '{}'", supplierArray2);
        Supplier[] supplierArray3 = new Supplier[1];
        supplierArray3[0] = dispatch::properties;
        LOGGER.atTrace().log("'{}'", supplierArray3);
    }

    @Override
    public void preSend(JmsDispatch dispatch, JmsMsg msg) {
        LOGGER.atTrace().log("'{}'", new Supplier[]{() -> msg == null ? "null" : msg.text()});
    }

    @Override
    public void postSend(JmsDispatch dispatch, JmsMsg msg) {
    }

    @Override
    public void onException(JmsDispatch dispatch, JmsMsg msg, Exception e) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = e::getMessage;
        LOGGER.atError().withThrowable((Throwable)e).log("Failed: {}", supplierArray);
    }
}

