/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.inbound;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import me.ehp246.aufjms.api.exception.UnknownTypeException;
import me.ehp246.aufjms.api.inbound.InboundEndpoint;
import me.ehp246.aufjms.api.inbound.Invocable;
import me.ehp246.aufjms.api.inbound.InvocableDispatcher;
import me.ehp246.aufjms.api.inbound.InvocableFactory;
import me.ehp246.aufjms.api.inbound.MsgConsumer;
import me.ehp246.aufjms.api.jms.AufJmsContext;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.Log4jContext;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.lang.Nullable;

final class DefaultInboundMessageListener
implements SessionAwareMessageListener<Message> {
    private static final Logger LOGGER = LogManager.getLogger(InboundEndpoint.class);
    private final InvocableDispatcher dispatcher;
    private final InvocableFactory invocableFactory;
    private final MsgConsumer defaultConsumer;

    DefaultInboundMessageListener(InvocableDispatcher dispatcher, InvocableFactory invocableFactory, @Nullable MsgConsumer defaultConsumer) {
        this.dispatcher = dispatcher;
        this.invocableFactory = invocableFactory;
        this.defaultConsumer = defaultConsumer;
    }

    public void onMessage(Message message, Session session) throws JMSException {
        if (!(message instanceof TextMessage)) {
            throw new IllegalArgumentException("Un-supported message type");
        }
        TextMessage textMessage = (TextMessage)message;
        JmsMsg msg = TextJmsMsg.from(textMessage);
        try {
            AufJmsContext.set(session);
            Log4jContext.set(msg);
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = msg::id;
            LOGGER.atDebug().log("Consuming {}", supplierArray);
            Supplier[] supplierArray2 = new Supplier[1];
            supplierArray2[0] = msg::text;
            LOGGER.atTrace().log("Consuming {}", supplierArray2);
            Invocable invocable = this.invocableFactory.get(msg);
            if (invocable == null) {
                if (this.defaultConsumer == null) {
                    throw new UnknownTypeException(msg);
                }
                this.defaultConsumer.accept(msg);
                return;
            }
            LOGGER.atDebug().log("Dispatching {}", new Supplier[]{() -> invocable.method().toString()});
            this.dispatcher.dispatch(invocable, msg);
            Supplier[] supplierArray3 = new Supplier[1];
            supplierArray3[0] = msg::id;
            LOGGER.atDebug().log("Consumed {}", supplierArray3);
        }
        catch (Exception e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            LOGGER.atError().withThrowable((Throwable)e).log("Message failed: {}", supplierArray);
            throw e;
        }
        finally {
            AufJmsContext.clearSession();
            Log4jContext.clear();
        }
    }
}

