/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import me.ehp246.aufjms.api.dispatch.DispatchListener;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.exception.JmsDispatchFailedException;
import me.ehp246.aufjms.api.jms.AtQueue;
import me.ehp246.aufjms.api.jms.AufJmsContext;
import me.ehp246.aufjms.api.jms.ConnectionFactoryProvider;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.jms.ToJson;
import me.ehp246.aufjms.api.spi.Log4jContext;
import me.ehp246.aufjms.core.util.OneUtil;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DefaultDispatchFnProvider
implements JmsDispatchFnProvider,
AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(DefaultDispatchFnProvider.class);
    private static final Set<String> RESERVED_PROPERTIES = Set.of("JMSXGroupID", "JMSXGroupSeq");
    private final ConnectionFactoryProvider cfProvider;
    private final ToJson toJson;
    private final List<DispatchListener.OnDispatch> onDispatchs = new ArrayList<DispatchListener.OnDispatch>();
    private final List<DispatchListener.PreSend> preSends = new ArrayList<DispatchListener.PreSend>();
    private final List<DispatchListener.PostSend> postSends = new ArrayList<DispatchListener.PostSend>();
    private final List<DispatchListener.OnException> onExs = new ArrayList<DispatchListener.OnException>();
    private final Set<Connection> closeable = ConcurrentHashMap.newKeySet();

    public DefaultDispatchFnProvider(ConnectionFactoryProvider cfProvider, ToJson jsonFn, List<DispatchListener> dispatchListeners) {
        this.cfProvider = Objects.requireNonNull(cfProvider);
        this.toJson = Objects.requireNonNull(jsonFn);
        for (Object listener : dispatchListeners == null ? List.of() : dispatchListeners) {
            if (listener instanceof DispatchListener.OnDispatch) {
                DispatchListener.OnDispatch onDispatch = (DispatchListener.OnDispatch)listener;
                this.onDispatchs.add(onDispatch);
            }
            if (listener instanceof DispatchListener.PreSend) {
                DispatchListener.PreSend preSend = (DispatchListener.PreSend)listener;
                this.preSends.add(preSend);
            }
            if (listener instanceof DispatchListener.PostSend) {
                DispatchListener.PostSend postSend = (DispatchListener.PostSend)listener;
                this.postSends.add(postSend);
            }
            if (!(listener instanceof DispatchListener.OnException)) continue;
            DispatchListener.OnException onEx = (DispatchListener.OnException)listener;
            this.onExs.add(onEx);
        }
    }

    @Override
    public JmsDispatchFn get(final String connectionFactoryName) {
        Connection connection;
        if (connectionFactoryName != null) {
            try {
                connection = this.cfProvider.get(connectionFactoryName).createConnection();
            }
            catch (JMSException e) {
                org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[2];
                supplierArray[0] = connectionFactoryName::toString;
                supplierArray[1] = e::getMessage;
                LOGGER.atError().withThrowable((Throwable)e).log("Failed to create connection on factory '{}': {}", supplierArray);
                throw new JMSRuntimeException(e.getErrorCode(), e.getMessage(), (Throwable)e);
            }
            this.closeable.add(connection);
        } else {
            connection = null;
        }
        return new JmsDispatchFn(){
            private final Logger LOGGER;
            {
                this.LOGGER = LogManager.getLogger((String)(JmsDispatchFn.class.getName() + "@" + connectionFactoryName));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public JmsMsg send(JmsDispatch dispatch) {
                JmsMsg jmsMsg;
                Session session;
                block29: {
                    Objects.requireNonNull(dispatch);
                    Log4jContext.set(dispatch);
                    session = null;
                    MessageProducer producer = null;
                    TextMessage message = null;
                    JmsMsg msg = null;
                    try {
                        for (DispatchListener.OnDispatch onDispatch : DefaultDispatchFnProvider.this.onDispatchs) {
                            onDispatch.onDispatch(dispatch);
                        }
                        if (connection == null && AufJmsContext.getSession() == null) {
                            throw new IllegalStateException("No session available");
                        }
                        if (dispatch.to() == null || !OneUtil.hasValue(dispatch.to().name())) {
                            throw new IllegalArgumentException("To must be specified");
                        }
                        Optional<Map<String, Object>> properties = Optional.ofNullable(dispatch.properties());
                        properties.map(Map::keySet).map(Collection::stream).flatMap(keys -> keys.filter(key -> RESERVED_PROPERTIES.contains(key)).findAny()).ifPresent(key -> {
                            throw new IllegalArgumentException("Un-allowed property name '" + key + "'");
                        });
                        session = connection != null ? connection.createSession() : AufJmsContext.getSession();
                        producer = session.createProducer(null);
                        message = session.createTextMessage();
                        msg = TextJmsMsg.from(message);
                        for (Map.Entry entry : properties.orElseGet(HashMap::new).entrySet()) {
                            message.setObjectProperty(((String)entry.getKey()).toString(), entry.getValue());
                        }
                        Queue queue = dispatch.to() instanceof AtQueue ? session.createQueue(dispatch.to().name()) : session.createTopic(dispatch.to().name());
                        message.setJMSDestination((Destination)queue);
                        message.setJMSType(dispatch.type());
                        message.setJMSCorrelationID(dispatch.correlationId());
                        if (dispatch.groupId() != null && !dispatch.groupId().isBlank()) {
                            message.setStringProperty("JMSXGroupID", dispatch.groupId());
                            message.setIntProperty("JMSXGroupSeq", dispatch.groupSeq());
                        }
                        if (dispatch.replyTo() != null) {
                            message.setJMSReplyTo((Destination)(dispatch.replyTo() instanceof AtQueue ? session.createQueue(dispatch.replyTo().name()) : session.createTopic(dispatch.replyTo().name())));
                        }
                        message.setText(this.toPayload(dispatch));
                        producer.setDeliveryDelay(Optional.ofNullable(dispatch.delay()).map(Duration::toMillis).orElse(0L).longValue());
                        producer.setTimeToLive(Optional.ofNullable(dispatch.ttl()).map(Duration::toMillis).orElse(0L).longValue());
                        for (DispatchListener.PreSend preSend : DefaultDispatchFnProvider.this.preSends) {
                            preSend.preSend(dispatch, msg);
                        }
                        producer.send((Destination)queue, (Message)message);
                        for (DispatchListener.PostSend postSend : DefaultDispatchFnProvider.this.postSends) {
                            try {
                                postSend.postSend(dispatch, msg);
                            }
                            catch (Exception e) {
                                org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[2];
                                supplierArray[0] = postSend::toString;
                                supplierArray[1] = e::getMessage;
                                this.LOGGER.atError().withThrowable((Throwable)e).log("Listener {} failed, ignoring: {}", supplierArray);
                            }
                        }
                        jmsMsg = msg;
                        if (producer == null) break block29;
                    }
                    catch (Exception e) {
                        try {
                            Iterator<DispatchListener.OnException> iterator = DefaultDispatchFnProvider.this.onExs.iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    throw new JmsDispatchFailedException("Dispatch failed, CorrelationId=" + dispatch.correlationId() + ", " + e.getMessage(), e);
                                }
                                DispatchListener.OnException onException = iterator.next();
                                try {
                                    onException.onException(dispatch, msg, e);
                                }
                                catch (Exception exception) {
                                    org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[2];
                                    supplierArray[0] = onException::toString;
                                    supplierArray[1] = exception::getMessage;
                                    this.LOGGER.atError().withThrowable((Throwable)exception).log("Listener {} failed, ignoring: {}", supplierArray);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            if (producer != null) {
                                try {
                                    producer.close();
                                }
                                catch (Exception e2) {
                                    org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[1];
                                    supplierArray[0] = e2::getMessage;
                                    this.LOGGER.atError().withThrowable((Throwable)e2).log("Ignored: {}", supplierArray);
                                }
                            }
                            if (connection != null && session != null) {
                                try {
                                    session.close();
                                }
                                catch (Exception e3) {
                                    org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[1];
                                    supplierArray[0] = e3::getMessage;
                                    this.LOGGER.atError().withThrowable((Throwable)e3).log("Ignored: {}", supplierArray);
                                }
                            }
                            Log4jContext.clearMsg();
                            throw throwable;
                        }
                    }
                    try {
                        producer.close();
                    }
                    catch (Exception exception) {
                        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[1];
                        supplierArray[0] = exception::getMessage;
                        this.LOGGER.atError().withThrowable((Throwable)exception).log("Ignored: {}", supplierArray);
                    }
                }
                if (connection != null && session != null) {
                    try {
                        session.close();
                    }
                    catch (Exception exception) {
                        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[1];
                        supplierArray[0] = exception::getMessage;
                        this.LOGGER.atError().withThrowable((Throwable)exception).log("Ignored: {}", supplierArray);
                    }
                }
                Log4jContext.clearMsg();
                return jmsMsg;
            }

            private String toPayload(JmsDispatch dispatch) {
                Object body = dispatch.body();
                if (body == null) {
                    return null;
                }
                if (body instanceof Supplier) {
                    Supplier supplier = (Supplier)body;
                    return Optional.ofNullable(supplier.get()).map(Object::toString).orElse(null);
                }
                return DefaultDispatchFnProvider.this.toJson.apply(body, dispatch.bodyOf());
            }
        };
    }

    @Override
    public void close() {
        this.closeable.stream().forEach(t -> {
            try {
                t.close();
            }
            catch (Exception e) {
                org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[1];
                supplierArray[0] = e::getMessage;
                LOGGER.atError().withThrowable((Throwable)e).log("Ignored: {}", supplierArray);
            }
        });
        this.closeable.clear();
    }
}

