/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.inbound;

import java.lang.reflect.Method;
import java.util.Objects;
import me.ehp246.aufjms.api.inbound.InstanceScope;
import me.ehp246.aufjms.api.inbound.Invocable;
import me.ehp246.aufjms.api.inbound.InvocableFactory;
import me.ehp246.aufjms.api.inbound.InvocableType;
import me.ehp246.aufjms.api.inbound.InvocableTypeRegistry;
import me.ehp246.aufjms.api.inbound.InvocationModel;
import me.ehp246.aufjms.api.jms.JmsMsg;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

final class AutowireCapableInvocableFactory
implements InvocableFactory {
    private final AutowireCapableBeanFactory autowireCapableBeanFactory;
    private final InvocableTypeRegistry registry;

    public AutowireCapableInvocableFactory(AutowireCapableBeanFactory autowireCapableBeanFactory, InvocableTypeRegistry registry) {
        this.autowireCapableBeanFactory = autowireCapableBeanFactory;
        this.registry = registry;
    }

    @Override
    public Invocable get(JmsMsg msg) {
        Objects.requireNonNull(msg);
        final InvocableType registered = this.registry.resolve(msg);
        if (registered == null) {
            return null;
        }
        final Object instance = registered.scope().equals((Object)InstanceScope.BEAN) ? this.autowireCapableBeanFactory.getBean(registered.instanceType()) : this.autowireCapableBeanFactory.createBean(registered.instanceType());
        return new Invocable(){

            @Override
            public Object instance() {
                return instance;
            }

            @Override
            public Method method() {
                return registered.method();
            }

            @Override
            public InvocationModel invocationModel() {
                return registered.model();
            }

            @Override
            public void close() throws Exception {
                if (registered.scope() == InstanceScope.BEAN) {
                    return;
                }
                AutowireCapableInvocableFactory.this.autowireCapableBeanFactory.destroyBean(instance);
            }
        };
    }
}

