/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.api.dispatch;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.ehp246.aufjms.api.dispatch.DispatchListener;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.exception.JmsDispatchFailedException;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.AtQueue;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.jms.ToJson;
import me.ehp246.aufjms.api.spi.Log4jContext;
import me.ehp246.aufjms.core.configuration.AufJmsConstants;
import me.ehp246.aufjms.core.util.OneUtil;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public final class DefaultDispatchFn
implements JmsDispatchFn {
    private final Logger LOGGER = LogManager.getLogger((String)JmsDispatchFn.class.getName());
    private final ToJson toJson;
    private final ConnectionFactory connectionFactory;
    private final JMSContext jmsContext;
    private final List<DispatchListener.OnDispatch> onDispatchs = new ArrayList<DispatchListener.OnDispatch>();
    private final List<DispatchListener.PreSend> preSends = new ArrayList<DispatchListener.PreSend>();
    private final List<DispatchListener.PostSend> postSends = new ArrayList<DispatchListener.PostSend>();
    private final List<DispatchListener.OnException> onExs = new ArrayList<DispatchListener.OnException>();

    public DefaultDispatchFn(ConnectionFactory connectionFactory, ToJson toJson, List<DispatchListener> dispatchListeners) {
        this.toJson = Objects.requireNonNull(toJson);
        this.connectionFactory = Objects.requireNonNull(connectionFactory);
        this.jmsContext = null;
        this.initListeners(dispatchListeners);
    }

    public DefaultDispatchFn(JMSContext jmsContex, ToJson toJson, List<DispatchListener> dispatchListeners) {
        this.toJson = Objects.requireNonNull(toJson);
        this.connectionFactory = null;
        this.jmsContext = Objects.requireNonNull(jmsContex);
        this.initListeners(dispatchListeners);
    }

    public DefaultDispatchFn(JMSContext jmsContex, ToJson toJson) {
        this.toJson = Objects.requireNonNull(toJson);
        this.connectionFactory = null;
        this.jmsContext = Objects.requireNonNull(jmsContex);
    }

    private void initListeners(List<DispatchListener> dispatchListeners) {
        for (Object listener : dispatchListeners == null ? List.of() : dispatchListeners) {
            if (listener instanceof DispatchListener.OnDispatch) {
                DispatchListener.OnDispatch onDispatch = (DispatchListener.OnDispatch)listener;
                this.onDispatchs.add(onDispatch);
            }
            if (listener instanceof DispatchListener.PreSend) {
                DispatchListener.PreSend preSend = (DispatchListener.PreSend)listener;
                this.preSends.add(preSend);
            }
            if (listener instanceof DispatchListener.PostSend) {
                DispatchListener.PostSend postSend = (DispatchListener.PostSend)listener;
                this.postSends.add(postSend);
            }
            if (!(listener instanceof DispatchListener.OnException)) continue;
            DispatchListener.OnException onEx = (DispatchListener.OnException)listener;
            this.onExs.add(onEx);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JmsMsg send(JmsDispatch dispatch) {
        JmsMsg jmsMsg;
        block20: {
            Objects.requireNonNull(dispatch);
            Log4jContext.set(dispatch);
            JMSContext localContext = null;
            TextMessage message = null;
            JmsMsg msg = null;
            try {
                for (DispatchListener.OnDispatch onDispatch : this.onDispatchs) {
                    onDispatch.onDispatch(dispatch);
                }
                localContext = this.jmsContext == null ? this.connectionFactory.createContext() : this.jmsContext;
                Optional<Map<String, Object>> properties = Optional.ofNullable(dispatch.properties());
                properties.map(Map::keySet).map(Collection::stream).flatMap(keys -> keys.filter(key -> AufJmsConstants.RESERVED_PROPERTIES.contains(key)).findAny()).ifPresent(key -> {
                    throw new IllegalArgumentException("Un-allowed property name '" + key + "'");
                });
                message = localContext.createTextMessage();
                msg = TextJmsMsg.from(message);
                for (Map.Entry entry : properties.orElseGet(HashMap::new).entrySet()) {
                    message.setObjectProperty(((String)entry.getKey()).toString(), entry.getValue());
                }
                message.setJMSType(dispatch.type());
                message.setJMSCorrelationID(dispatch.correlationId());
                if (dispatch.groupId() != null && !dispatch.groupId().isBlank()) {
                    message.setStringProperty("JMSXGroupID", dispatch.groupId());
                    message.setIntProperty("JMSXGroupSeq", dispatch.groupSeq());
                }
                message.setJMSReplyTo(this.toJMSDestintation(localContext, dispatch.replyTo()));
                message.setText(this.toPayload(dispatch));
                JMSProducer jMSProducer = localContext.createProducer().setDeliveryDelay(Optional.ofNullable(dispatch.delay()).map(Duration::toMillis).orElse(0L).longValue()).setTimeToLive(Optional.ofNullable(dispatch.ttl()).map(Duration::toMillis).orElse(0L).longValue());
                for (DispatchListener.PreSend preSend : this.preSends) {
                    preSend.preSend(dispatch, msg);
                }
                jMSProducer.send(this.toJMSDestintation(localContext, dispatch.to()), (Message)message);
                for (DispatchListener.PostSend postSend : this.postSends) {
                    try {
                        postSend.postSend(dispatch, msg);
                    }
                    catch (Exception e) {
                        Supplier[] supplierArray = new Supplier[2];
                        supplierArray[0] = postSend::toString;
                        supplierArray[1] = e::getMessage;
                        this.LOGGER.atTrace().withThrowable((Throwable)e).log("Listener {} failed, ignoring: {}", supplierArray);
                    }
                }
                jmsMsg = msg;
                if (this.jmsContext != null || localContext == null) break block20;
            }
            catch (Exception e) {
                try {
                    Iterator<DispatchListener.OnException> iterator = this.onExs.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw new JmsDispatchFailedException("Dispatch failed, CorrelationId=" + dispatch.correlationId() + ", " + e.getMessage(), e);
                        }
                        DispatchListener.OnException onException = iterator.next();
                        try {
                            onException.onException(dispatch, msg, e);
                        }
                        catch (Exception exception) {
                            Supplier[] supplierArray = new Supplier[2];
                            supplierArray[0] = onException::toString;
                            supplierArray[1] = exception::getMessage;
                            this.LOGGER.atTrace().withThrowable((Throwable)exception).log("Listener {} failed, ignoring: {}", supplierArray);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (this.jmsContext == null && localContext != null) {
                        try {
                            localContext.close();
                        }
                        catch (Exception e2) {
                            Supplier[] supplierArray = new Supplier[1];
                            supplierArray[0] = e2::getMessage;
                            this.LOGGER.atTrace().withThrowable((Throwable)e2).log("JMSCOntext close failed, ignoring: {}", supplierArray);
                        }
                    }
                    Log4jContext.clear(dispatch);
                    throw throwable;
                }
            }
            try {
                localContext.close();
            }
            catch (Exception exception) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = exception::getMessage;
                this.LOGGER.atTrace().withThrowable((Throwable)exception).log("JMSCOntext close failed, ignoring: {}", supplierArray);
            }
        }
        Log4jContext.clear(dispatch);
        return jmsMsg;
    }

    private String toPayload(JmsDispatch dispatch) {
        Object body = dispatch.body();
        if (body == null) {
            return null;
        }
        if (body instanceof java.util.function.Supplier) {
            java.util.function.Supplier supplier = (java.util.function.Supplier)body;
            return Optional.ofNullable(supplier.get()).map(Object::toString).orElse(null);
        }
        return this.toJson.apply(body, dispatch.bodyOf());
    }

    private Destination toJMSDestintation(JMSContext jmsContext, At to) {
        if (to == null || !OneUtil.hasValue(to.name())) {
            return null;
        }
        return to instanceof AtQueue ? jmsContext.createQueue(to.name()) : jmsContext.createTopic(to.name());
    }
}

