/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.api.jms;

import jakarta.jms.JMSContext;

public final class JmsDispatchContext {
    private static final ThreadLocal<JMSContext> localContext = ThreadLocal.withInitial(() -> null);

    private JmsDispatchContext() {
    }

    public static AutoCloseable set(JMSContext jmsContext) {
        localContext.set(jmsContext);
        return JmsDispatchContext.closeable();
    }

    public static JMSContext getJmsContext() {
        return localContext.get();
    }

    public static void remove() {
        localContext.remove();
    }

    public static AutoCloseable closeable() {
        return () -> {
            JMSContext jmsContext = localContext.get();
            JmsDispatchContext.remove();
            if (jmsContext != null) {
                jmsContext.close();
            }
        };
    }
}

