/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import com.fasterxml.jackson.annotation.JsonView;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import me.ehp246.aufjms.api.annotation.OfCorrelationId;
import me.ehp246.aufjms.api.annotation.OfDelay;
import me.ehp246.aufjms.api.annotation.OfGroupId;
import me.ehp246.aufjms.api.annotation.OfGroupSeq;
import me.ehp246.aufjms.api.annotation.OfProperty;
import me.ehp246.aufjms.api.annotation.OfTtl;
import me.ehp246.aufjms.api.annotation.OfType;
import me.ehp246.aufjms.api.dispatch.ByJmsProxyConfig;
import me.ehp246.aufjms.api.jms.BodyOf;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.dispatch.DefaultProxyInvocationBinder;
import me.ehp246.aufjms.core.dispatch.ProxyInvocationBinder;
import me.ehp246.aufjms.core.reflection.ReflectedParameter;
import me.ehp246.aufjms.core.reflection.ReflectedProxyMethod;
import me.ehp246.aufjms.core.util.OneUtil;

final class DefaultProxyMethodParser {
    private static final Set<Class<? extends Annotation>> PARAMETER_ANNOTATIONS = Set.of(OfType.class, OfProperty.class, OfTtl.class, OfDelay.class, OfCorrelationId.class);
    private final PropertyResolver propertyResolver;

    DefaultProxyMethodParser(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    ProxyInvocationBinder parse(Method method, ByJmsProxyConfig config) {
        ReflectedProxyMethod reflected = new ReflectedProxyMethod(method);
        Function typeFn = reflected.allParametersWith(OfType.class).stream().findFirst().map(p -> args -> (String)args[p.index()]).orElseGet(() -> reflected.findOnMethodUp(OfType.class).map(an -> args -> an.value()).orElseGet(() -> args -> OneUtil.firstUpper(method.getName())));
        Function correlIdFn = reflected.allParametersWith(OfCorrelationId.class).stream().findFirst().map(p -> {
            int index = p.index();
            return args -> (String)args[index];
        }).orElse(null);
        Function ttlFn = reflected.allParametersWith(OfTtl.class).stream().findFirst().map(p -> args -> (Duration)args[p.index()]).orElseGet(() -> reflected.findOnMethodUp(OfTtl.class).map(a -> args -> Duration.parse(this.propertyResolver.resolve(a.value()))).orElse(null));
        Function delayFn = reflected.allParametersWith(OfDelay.class).stream().findFirst().map(p -> {
            Class<Object> type = p.parameter().getType();
            if (type.isAssignableFrom(String.class)) {
                return args -> {
                    Object delayArg = args[p.index()];
                    if (delayArg == null) {
                        return null;
                    }
                    return Duration.parse((String)delayArg);
                };
            }
            if (type.isAssignableFrom(Duration.class)) {
                return args -> (Duration)args[p.index()];
            }
            throw new IllegalArgumentException("Un-supported Delay type '" + type.getName() + "' on '" + reflected.method().toString() + "'");
        }).orElseGet(() -> reflected.findOnMethodUp(OfDelay.class).map(a -> {
            Duration parsed = Duration.parse(this.propertyResolver.resolve(a.value()));
            return args -> parsed;
        }).orElse(null));
        Function groupIdFn = reflected.allParametersWith(OfGroupId.class).stream().findFirst().map(p -> {
            Class<String> type = p.parameter().getType();
            if (type.isAssignableFrom(String.class)) {
                return args -> (String)args[p.index()];
            }
            throw new IllegalArgumentException("Un-supported GroupId type '" + type.getName() + "' on '" + reflected.method().toString() + "'");
        }).orElseGet(() -> reflected.findOnMethodUp(OfGroupId.class).map(a -> {
            String parsed = this.propertyResolver.resolve(a.value());
            return args -> parsed;
        }).orElse(null));
        Function groupSeqFn = reflected.allParametersWith(OfGroupSeq.class).stream().findFirst().map(p -> {
            Class<Integer> type = p.parameter().getType();
            if (type == Integer.TYPE || type.isAssignableFrom(Integer.class)) {
                return args -> (Integer)args[p.index()];
            }
            throw new IllegalArgumentException("Un-supported GroupSeq type '" + type.getName() + "' on '" + reflected.method().toString() + "'");
        }).orElse(null);
        Integer bodyIndex = reflected.firstPayloadParameter(PARAMETER_ANNOTATIONS).map(ReflectedParameter::index).orElse(-1);
        BodyOf bodyOf = Optional.ofNullable(bodyIndex == -1 ? null : reflected.getParameter(bodyIndex)).map(parameter -> new BodyOf(Optional.ofNullable(parameter.getAnnotation(JsonView.class)).map(JsonView::value).filter(OneUtil::hasValue).map(views -> views[0]).orElse(null), parameter.getType())).orElse(null);
        return new DefaultProxyInvocationBinder(reflected, config, typeFn, correlIdFn, bodyIndex, bodyOf, this.propArgs(reflected), this.propStatic(reflected, config), ttlFn, delayFn, groupIdFn, groupSeqFn);
    }

    private Map<String, String> propStatic(ReflectedProxyMethod reflected, ByJmsProxyConfig config) {
        List<String> properties = config.properties();
        if ((properties.size() & 1) != 0) {
            throw new IllegalArgumentException("Properties should be in name/value pairs on " + reflected.method().getDeclaringClass());
        }
        HashMap<String, String> propStatic = new HashMap<String, String>();
        for (int i = 0; i < properties.size(); i += 2) {
            String key = properties.get(i);
            if (propStatic.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate '" + properties.get(i) + " on " + reflected.method().getDeclaringClass());
            }
            propStatic.put(key, this.propertyResolver.resolve(properties.get(i + 1)));
        }
        return propStatic;
    }

    private Map<Integer, DefaultProxyInvocationBinder.PropertyArg> propArgs(ReflectedProxyMethod reflected) {
        HashMap<Integer, DefaultProxyInvocationBinder.PropertyArg> propArgs = new HashMap<Integer, DefaultProxyInvocationBinder.PropertyArg>();
        for (ReflectedParameter p : reflected.allParametersWith(OfProperty.class)) {
            Parameter parameter = p.parameter();
            propArgs.put(p.index(), new DefaultProxyInvocationBinder.PropertyArg(OneUtil.getIfBlank(parameter.getAnnotation(OfProperty.class).value(), () -> OneUtil.firstUpper(parameter.getName())), parameter.getType()));
        }
        return propArgs;
    }
}

