/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.ehp246.aufjms.api.annotation.ByJms;
import me.ehp246.aufjms.api.annotation.EnableByJms;
import me.ehp246.aufjms.api.dispatch.EnableByJmsConfig;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.core.dispatch.ByJmsProxyFactory;
import me.ehp246.aufjms.core.dispatch.DefaultDispatchFnProvider;
import me.ehp246.aufjms.core.dispatch.EnableByJmsBeanFactory;
import me.ehp246.aufjms.core.reflection.EnabledScanner;
import me.ehp246.aufjms.core.util.OneUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionOverrideException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public final class EnableByJmsRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger LOGGER = LogManager.getLogger(EnableByJmsRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map enableMap = metadata.getAnnotationAttributes(EnableByJms.class.getCanonicalName());
        this.register(registry, this.beanName(EnableByJmsConfig.class), this.getAppConfigBeanDefinition(enableMap));
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = ByJms.class::getCanonicalName;
        LOGGER.atTrace().log("Scanning for {}", supplierArray);
        for (BeanDefinition found : new EnabledScanner(EnableByJms.class, ByJms.class, metadata).perform().collect(Collectors.toList())) {
            Class<?> proxyInterface;
            Supplier[] supplierArray2 = new Supplier[1];
            supplierArray2[0] = () -> ((BeanDefinition)found).getBeanClassName();
            LOGGER.atTrace().log("Registering {}", supplierArray2);
            try {
                proxyInterface = Class.forName(found.getBeanClassName());
            }
            catch (ClassNotFoundException ignored) {
                throw new RuntimeException("Class scanning started this. Should not happen.");
            }
            String beanName = Optional.ofNullable(proxyInterface.getAnnotation(ByJms.class).name()).filter(OneUtil::hasValue).orElseGet(() -> this.beanName(proxyInterface));
            BeanDefinition proxyBeanDefinition = this.getProxyBeanDefinition(proxyInterface);
            this.register(registry, beanName, proxyBeanDefinition);
        }
        Map enablerAttributes = metadata.getAnnotationAttributes(EnableByJms.class.getCanonicalName());
        String[] fns = (String[])enablerAttributes.get("dispatchFns");
        if (fns.length == 0) {
            return;
        }
        for (int i = 0; i < fns.length; ++i) {
            this.register(registry, "jmsDispatchFn-" + i, this.getFnBeanDefinition(fns[i]));
        }
    }

    private void register(BeanDefinitionRegistry registry, String beanName, BeanDefinition newDefinition) {
        if (registry.containsBeanDefinition(beanName)) {
            throw new BeanDefinitionOverrideException(beanName, newDefinition, registry.getBeanDefinition(beanName));
        }
        registry.registerBeanDefinition(beanName, newDefinition);
    }

    private String beanName(Class<?> type) {
        char[] c = type.getSimpleName().toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    private BeanDefinition getAppConfigBeanDefinition(Map<String, Object> map) {
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addGenericArgumentValue(Arrays.asList((Class[])map.get("scan")));
        args.addGenericArgumentValue(map.get("ttl"));
        args.addGenericArgumentValue(map.get("delay"));
        args.addGenericArgumentValue(Arrays.asList((String[])map.get("dispatchFns")));
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(EnableByJmsConfig.class);
        beanDefinition.setConstructorArgumentValues(args);
        beanDefinition.setFactoryBeanName(EnableByJmsBeanFactory.class.getName());
        beanDefinition.setFactoryMethodName("enableByJmsConfig");
        return beanDefinition;
    }

    private BeanDefinition getFnBeanDefinition(String name) {
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addGenericArgumentValue((Object)name);
        GenericBeanDefinition proxyBeanDefinition = new GenericBeanDefinition();
        proxyBeanDefinition.setBeanClass(JmsDispatchFn.class);
        proxyBeanDefinition.setConstructorArgumentValues(args);
        proxyBeanDefinition.setFactoryBeanName(DefaultDispatchFnProvider.class.getName());
        proxyBeanDefinition.setFactoryMethodName("get");
        return proxyBeanDefinition;
    }

    private BeanDefinition getProxyBeanDefinition(Class<?> proxyInterface) {
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addGenericArgumentValue(proxyInterface);
        GenericBeanDefinition proxyBeanDefinition = new GenericBeanDefinition();
        proxyBeanDefinition.setBeanClass(proxyInterface);
        proxyBeanDefinition.setConstructorArgumentValues(args);
        proxyBeanDefinition.setFactoryBeanName(ByJmsProxyFactory.class.getName());
        proxyBeanDefinition.setFactoryMethodName("newByJmsProxy");
        return proxyBeanDefinition;
    }
}

