/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.inbound;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import me.ehp246.aufjms.api.inbound.InvocableType;
import me.ehp246.aufjms.api.inbound.InvocableTypeDefinition;
import me.ehp246.aufjms.api.inbound.InvocableTypeRegistry;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.util.OneUtil;

final class DefaultInvocableRegistry
implements InvocableTypeRegistry {
    private final Map<String, InvocableTypeDefinition> cached = new ConcurrentHashMap<String, InvocableTypeDefinition>();
    private final Map<String, InvocableTypeDefinition> registeredInvokables = new ConcurrentHashMap<String, InvocableTypeDefinition>();
    private final Map<Class<?>, Map<String, Method>> registeredMethods = new ConcurrentHashMap();

    DefaultInvocableRegistry() {
    }

    public DefaultInvocableRegistry register(Stream<InvocableTypeDefinition> invokingDefinitions) {
        invokingDefinitions.forEach(this::register);
        return this;
    }

    @Override
    public void register(InvocableTypeDefinition invokingDefinition) {
        invokingDefinition.msgTypes().forEach(type -> {
            InvocableTypeDefinition registered = this.registeredInvokables.putIfAbsent((String)type, invokingDefinition);
            if (registered != null) {
                throw new IllegalArgumentException("Duplicate type " + type + " from " + registered.type());
            }
            this.registeredMethods.put(invokingDefinition.type(), invokingDefinition.methods());
        });
    }

    @Override
    public Map<String, InvocableTypeDefinition> registered() {
        return Collections.unmodifiableMap(this.registeredInvokables);
    }

    @Override
    public InvocableType resolve(JmsMsg msg) {
        String msgType = OneUtil.toString(Objects.requireNonNull(msg).type(), "");
        InvocableTypeDefinition definition = this.cached.computeIfAbsent(msgType, key -> this.registeredInvokables.entrySet().stream().filter(e -> msgType.matches((String)e.getKey())).findAny().map(Map.Entry::getValue).orElse(null));
        if (definition == null) {
            return null;
        }
        String invoking = msg.invoking();
        invoking = invoking != null ? invoking.strip() : "";
        Method method = this.registeredMethods.get(definition.type()).get(invoking);
        if (method == null) {
            return null;
        }
        return new InvocableType(definition.type(), method, definition.scope(), definition.model());
    }
}

