/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.inbound;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.ehp246.aufjms.api.inbound.InboundEndpoint;
import me.ehp246.aufjms.api.inbound.InvocationListener;
import me.ehp246.aufjms.api.inbound.MsgConsumer;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.DestinationType;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.inbound.DefaultInvocableRegistry;
import me.ehp246.aufjms.core.inbound.DefaultInvocableScanner;
import me.ehp246.aufjms.core.inbound.InboundEndpointRecord;
import me.ehp246.aufjms.core.util.OneUtil;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public final class InboundEndpointFactory {
    private final PropertyResolver propertyResolver;
    private final AutowireCapableBeanFactory autowireCapableBeanFactory;
    private final DefaultInvocableScanner invocableScanner;

    public InboundEndpointFactory(AutowireCapableBeanFactory autowireCapableBeanFactory, PropertyResolver propertyResolver) {
        this.autowireCapableBeanFactory = autowireCapableBeanFactory;
        this.propertyResolver = propertyResolver;
        this.invocableScanner = new DefaultInvocableScanner(propertyResolver);
    }

    public InboundEndpoint newInstance(Map<String, Object> inboundAttributes, Set<String> scanPackages, String beanName, String defaultConsumerName) {
        MsgConsumer defaultConsumer = Optional.ofNullable(defaultConsumerName).map(this.propertyResolver::resolve).filter(OneUtil::hasValue).map(name -> (MsgConsumer)this.autowireCapableBeanFactory.getBean(name, MsgConsumer.class)).orElse(null);
        Map fromAttribute = (Map)inboundAttributes.get("value");
        Map subAttribute = (Map)fromAttribute.get("sub");
        String atName = this.propertyResolver.resolve(fromAttribute.get("value").toString());
        DestinationType atType = (DestinationType)((Object)fromAttribute.get("type"));
        InboundEndpointRecord.From from = new InboundEndpointRecord.From(atType == DestinationType.TOPIC ? At.toTopic(atName) : At.toQueue(atName), this.propertyResolver.resolve(fromAttribute.get("selector").toString()), new InboundEndpointRecord.Sub(this.propertyResolver.resolve(subAttribute.get("name").toString()), (Boolean)subAttribute.get("shared"), (Boolean)subAttribute.get("durable")));
        int concurrency = Integer.parseInt(this.propertyResolver.resolve(inboundAttributes.get("concurrency").toString()));
        boolean autoStartup = Boolean.parseBoolean(this.propertyResolver.resolve(inboundAttributes.get("autoStartup").toString()));
        String connectionFactory = this.propertyResolver.resolve(inboundAttributes.get("connectionFactory").toString());
        DefaultInvocableRegistry registery = this.invocableScanner.registeryFrom((Class[])inboundAttributes.get("register"), scanPackages);
        InvocationListener invocationListener = Optional.ofNullable(inboundAttributes.get("invocationListener").toString()).map(this.propertyResolver::resolve).filter(OneUtil::hasValue).map(name -> (InvocationListener)this.autowireCapableBeanFactory.getBean(name, InvocationListener.class)).orElse(null);
        return new InboundEndpointRecord(from, registery, concurrency, beanName, autoStartup, connectionFactory, invocationListener, defaultConsumer, (Integer)inboundAttributes.get("sessionMode"));
    }
}

