/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.dispatch.DispatchMethodBinder;
import me.ehp246.aufjms.core.dispatch.InvocationReturnBinder;
import me.ehp246.aufjms.core.dispatch.LocalReturnBinder;
import me.ehp246.aufjms.core.dispatch.RemoteReturnBinder;
import me.ehp246.aufjms.core.dispatch.RequestDispatchMap;

final class ProxyInvocationHandler
implements InvocationHandler {
    private final Class<?> proxyInterface;
    private final int hashCode = new Object().hashCode();
    private final JmsDispatchFn dispatchFn;
    private final Function<Method, DispatchMethodBinder> methodBinderSupplier;
    private final RequestDispatchMap futureMap;

    ProxyInvocationHandler(Class<?> proxyInterface, JmsDispatchFn dispatchFn, Function<Method, DispatchMethodBinder> methodBinderSupplier, RequestDispatchMap futureMap) {
        this.proxyInterface = proxyInterface;
        this.dispatchFn = dispatchFn;
        this.methodBinderSupplier = methodBinderSupplier;
        this.futureMap = futureMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("toString")) {
            return this.toString();
        }
        if (method.getName().equals("hashCode")) {
            return this.hashCode;
        }
        if (method.getName().equals("equals")) {
            return proxy == args[0];
        }
        if (method.isDefault()) {
            return MethodHandles.privateLookupIn(this.proxyInterface, MethodHandles.lookup()).findSpecial(this.proxyInterface, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), this.proxyInterface).bindTo(proxy).invokeWithArguments(args);
        }
        DispatchMethodBinder methodBinder = this.methodBinderSupplier.apply(method);
        JmsDispatch jmsDispatch = methodBinder.invocationBinder().apply(proxy, args);
        InvocationReturnBinder returnBinder = methodBinder.returnBinder();
        CompletableFuture<JmsMsg> futureMsg = returnBinder instanceof RemoteReturnBinder ? this.futureMap.add(jmsDispatch.correlationId()) : null;
        this.dispatchFn.send(jmsDispatch);
        if (futureMsg == null) {
            return ((LocalReturnBinder)returnBinder).apply(jmsDispatch);
        }
        try {
            Object object = ((RemoteReturnBinder)returnBinder).apply(jmsDispatch, futureMsg);
            return object;
        }
        finally {
            this.futureMap.remove(jmsDispatch.correlationId());
        }
    }
}

